(*  Title:      HOL/UNITY/Union.ML
    ID:         $Id$
    Author:     Lawrence C Paulson, Cambridge University Computer Laboratory
    Copyright   1998  University of Cambridge

Unions of programs

From Misra's Chapter 5: Asynchronous Compositions of Programs
*)


(** SKIP **)

Goal "Init SKIP = UNIV";
by (simp_tac (simpset() addsimps [SKIP_def]) 1);
qed "Init_SKIP";

Goal "Acts SKIP = {Id}";
by (simp_tac (simpset() addsimps [SKIP_def]) 1);
qed "Acts_SKIP";

Goal "AllowedActs SKIP = UNIV";
by (auto_tac (claset(), simpset() addsimps [SKIP_def]));  
qed "AllowedActs_SKIP";

Addsimps [Init_SKIP, Acts_SKIP, AllowedActs_SKIP];

Goal "reachable SKIP = UNIV";
by (force_tac (claset() addEs [reachable.induct]
			addIs reachable.intrs, simpset()) 1);
qed "reachable_SKIP";

Addsimps [reachable_SKIP];

(** SKIP and safety properties **)

Goalw [constrains_def] "(SKIP : A co B) = (A<=B)";
by Auto_tac;
qed "SKIP_in_constrains_iff";
AddIffs [SKIP_in_constrains_iff];

Goalw [Constrains_def] "(SKIP : A Co B) = (A<=B)";
by Auto_tac;
qed "SKIP_in_Constrains_iff";
AddIffs [SKIP_in_Constrains_iff];

Goalw [stable_def] "SKIP : stable A";
by Auto_tac;
qed "SKIP_in_stable";
AddIffs [SKIP_in_stable, SKIP_in_stable RS stable_imp_Stable];


(** Join **)

Goal "Init (F Join G) = Init F Int Init G";
by (simp_tac (simpset() addsimps [Join_def]) 1);
qed "Init_Join";

Goal "Acts (F Join G) = Acts F Un Acts G";
by (auto_tac (claset(), simpset() addsimps [Join_def]));
qed "Acts_Join";

Goal "AllowedActs (F Join G) = AllowedActs F Int AllowedActs G";
by (auto_tac (claset(), simpset() addsimps [Join_def]));
qed "AllowedActs_Join";

Addsimps [Init_Join, Acts_Join, AllowedActs_Join];


(** JN **)

Goalw [JOIN_def, SKIP_def] "(JN i:{}. F i) = SKIP";
by Auto_tac;
qed "JN_empty";
Addsimps [JN_empty];

Goal "(JN i:insert a I. F i) = (F a) Join (JN i:I. F i)";
by (rtac program_equalityI 1);
by (auto_tac (claset(), simpset() addsimps [JOIN_def, Join_def]));  
qed "JN_insert";
Addsimps[JN_empty, JN_insert];

Goal "Init (JN i:I. F i) = (INT i:I. Init (F i))";
by (simp_tac (simpset() addsimps [JOIN_def]) 1);
qed "Init_JN";

Goal "Acts (JN i:I. F i) = insert Id (UN i:I. Acts (F i))";
by (auto_tac (claset(), simpset() addsimps [JOIN_def]));
qed "Acts_JN";

Goal "AllowedActs (JN i:I. F i) = (INT i:I. AllowedActs (F i))";
by (auto_tac (claset(), simpset() addsimps [JOIN_def]));
qed "AllowedActs_JN";

Addsimps [Init_JN, Acts_JN, AllowedActs_JN];

val prems = Goalw [JOIN_def]
    "[| I=J;  !!i. i:J ==> F i = G i |] ==> \
\    (JN i:I. F i) = (JN i:J. G i)";
by (asm_simp_tac (simpset() addsimps prems) 1);
qed "JN_cong";

Addcongs [JN_cong];


(** Algebraic laws **)

Goal "F Join G = G Join F";
by (simp_tac (simpset() addsimps [Join_def, Un_commute, Int_commute]) 1);
qed "Join_commute";


Goal "A Join (B Join C) = B Join (A Join C)";
by (simp_tac (simpset() addsimps Un_ac@Int_ac@[Join_def, insert_absorb]) 1);
qed "Join_left_commute";


Goal "(F Join G) Join H = F Join (G Join H)";
by (simp_tac (simpset() addsimps Un_ac@[Join_def, Int_assoc, insert_absorb]) 1);
qed "Join_assoc";
 
Goalw [Join_def, SKIP_def] "SKIP Join F = F";
by (rtac program_equalityI 1);
by (ALLGOALS (simp_tac (simpset() addsimps [insert_absorb])));
qed "Join_SKIP_left";

Goalw [Join_def, SKIP_def] "F Join SKIP = F";
by (rtac program_equalityI 1);
by (ALLGOALS (simp_tac (simpset() addsimps [insert_absorb])));
qed "Join_SKIP_right";

Addsimps [Join_SKIP_left, Join_SKIP_right];

Goalw [Join_def] "F Join F = F";
by (rtac program_equalityI 1);
by Auto_tac;
qed "Join_absorb";

Addsimps [Join_absorb];

Goalw [Join_def] "F Join (F Join G) = F Join G";
by (rtac program_equalityI 1);
by Auto_tac;
qed "Join_left_absorb";

(*Join is an AC-operator*)
val Join_ac = [Join_assoc, Join_left_absorb, Join_commute, Join_left_commute];


(*** JN laws ***)

(*Also follows by JN_insert and insert_absorb, but the proof is longer*)
Goal "k:I ==> F k Join (JN i:I. F i) = (JN i:I. F i)";
by (auto_tac (claset() addSIs [program_equalityI], simpset()));
qed "JN_absorb";

Goal "(JN i: I Un J. F i) = ((JN i: I. F i) Join (JN i:J. F i))";
by (auto_tac (claset() addSIs [program_equalityI], simpset()));
qed "JN_Un";

Goal "(JN i:I. c) = (if I={} then SKIP else c)";
by (rtac program_equalityI 1);
by Auto_tac;
qed "JN_constant";

Goal "(JN i:I. F i Join G i) = (JN i:I. F i)  Join  (JN i:I. G i)";
by (auto_tac (claset() addSIs [program_equalityI], simpset()));
qed "JN_Join_distrib";

Goal "i : I ==> (JN i:I. F i Join G) = ((JN i:I. F i) Join G)";
by (asm_simp_tac (simpset() addsimps [JN_Join_distrib, JN_constant]) 1);
by Auto_tac;
qed "JN_Join_miniscope";

(*Used to prove guarantees_JN_I*)
Goalw  [JOIN_def, Join_def] "i: I ==> F i Join JOIN (I - {i}) F = JOIN I F";
by (rtac program_equalityI 1);
by Auto_tac;
qed "JN_Join_diff";


(*** Safety: co, stable, FP ***)

(*Fails if I={} because it collapses to SKIP : A co B, i.e. to A<=B.  So an
  alternative precondition is A<=B, but most proofs using this rule require
  I to be nonempty for other reasons anyway.*)
Goalw [constrains_def, JOIN_def]
    "i : I ==> (JN i:I. F i) : A co B = (ALL i:I. F i : A co B)";
by (Simp_tac 1);
by (Blast_tac 1);
qed "JN_constrains";

Goal "(F Join G : A co B) = (F : A co B & G : A co B)";
by (auto_tac
    (claset(),
     simpset() addsimps [constrains_def, Join_def]));
qed "Join_constrains";

Goal "(F Join G : A unless B) = (F : A unless B & G : A unless B)";
by (simp_tac (simpset() addsimps [Join_constrains, unless_def]) 1);
qed "Join_unless";

Addsimps [Join_constrains, Join_unless];

(*Analogous weak versions FAIL; see Misra [1994] 5.4.1, Substitution Axiom.
  reachable (F Join G) could be much bigger than reachable F, reachable G
*)


Goal "[| F : A co A';  G : B co B' |] \
\     ==> F Join G : (A Int B) co (A' Un B')";
by (Simp_tac 1);
by (blast_tac (claset() addIs [constrains_weaken]) 1);
qed "Join_constrains_weaken";

(*If I={}, it degenerates to SKIP : UNIV co {}, which is false.*)
Goal "[| ALL i:I. F i : A i co A' i;  i: I |] \
\     ==> (JN i:I. F i) : (INT i:I. A i) co (UN i:I. A' i)";
by (asm_simp_tac (simpset() addsimps [JN_constrains]) 1);
by (blast_tac (claset() addIs [constrains_weaken]) 1);
qed "JN_constrains_weaken";

Goal "(JN i:I. F i) : stable A = (ALL i:I. F i : stable A)";
by (asm_simp_tac 
    (simpset() addsimps [stable_def, constrains_def, JOIN_def]) 1);
qed "JN_stable";

Goal "[| ALL i:I. F i : invariant A;  i : I |]  \
\      ==> (JN i:I. F i) : invariant A";
by (asm_full_simp_tac (simpset() addsimps [invariant_def, JN_stable]) 1);
by (Blast_tac 1);
bind_thm ("invariant_JN_I", ballI RS result());

Goal "(F Join G : stable A) = \
\     (F : stable A & G : stable A)";
by (simp_tac (simpset() addsimps [stable_def]) 1);
qed "Join_stable";

Goal "(F Join G : increasing f) = \
\     (F : increasing f & G : increasing f)";
by (simp_tac (simpset() addsimps [increasing_def, Join_stable]) 1);
by (Blast_tac 1);
qed "Join_increasing";

Addsimps [Join_stable, Join_increasing];

Goal "[| F : invariant A; G : invariant A |]  \
\     ==> F Join G : invariant A";
by (full_simp_tac (simpset() addsimps [invariant_def]) 1);
by (Blast_tac 1);
qed "invariant_JoinI";

Goal "FP (JN i:I. F i) = (INT i:I. FP (F i))";
by (asm_simp_tac (simpset() addsimps [FP_def, JN_stable, INTER_def]) 1);
qed "FP_JN";


(*** Progress: transient, ensures ***)

Goal "i : I ==> \
\   (JN i:I. F i) : transient A = (EX i:I. F i : transient A)";
by (auto_tac (claset(),
	      simpset() addsimps [transient_def, JOIN_def]));
qed "JN_transient";

Goal "F Join G : transient A = \
\     (F : transient A | G : transient A)";
by (auto_tac (claset(),
	      simpset() addsimps [bex_Un, transient_def,
				  Join_def]));
qed "Join_transient";

Addsimps [Join_transient];

Goal "F : transient A ==> F Join G : transient A";
by (asm_simp_tac (simpset() addsimps [Join_transient]) 1);
qed "Join_transient_I1";

Goal "G : transient A ==> F Join G : transient A";
by (asm_simp_tac (simpset() addsimps [Join_transient]) 1);
qed "Join_transient_I2";

(*If I={} it degenerates to (SKIP : A ensures B) = False, i.e. to ~(A<=B) *)
Goal "i : I ==> \
\     (JN i:I. F i) : A ensures B = \
\     ((ALL i:I. F i : (A-B) co (A Un B)) & (EX i:I. F i : A ensures B))";
by (auto_tac (claset(),
	      simpset() addsimps [ensures_def, JN_constrains, JN_transient]));
qed "JN_ensures";

Goalw [ensures_def]
     "F Join G : A ensures B =     \
\     (F : (A-B) co (A Un B) & G : (A-B) co (A Un B) & \
\      (F : transient (A-B) | G : transient (A-B)))";
by (auto_tac (claset(), simpset() addsimps [Join_transient]));
qed "Join_ensures";

Goalw [stable_def, constrains_def, Join_def]
    "[| F : stable A;  G : A co A' |] \
\    ==> F Join G : A co A'";
by (asm_full_simp_tac (simpset() addsimps [ball_Un]) 1);
by (Blast_tac 1);
qed "stable_Join_constrains";

(*Premise for G cannot use Always because  F: Stable A  is weaker than
  G : stable A *)
Goal "[| F : stable A;  G : invariant A |] ==> F Join G : Always A";
by (full_simp_tac (simpset() addsimps [Always_def, invariant_def, 
				       Stable_eq_stable]) 1);
by (force_tac(claset() addIs [stable_Int], simpset()) 1);
qed "stable_Join_Always1";

(*As above, but exchanging the roles of F and G*)
Goal "[| F : invariant A;  G : stable A |] ==> F Join G : Always A";
by (stac Join_commute 1);
by (blast_tac (claset() addIs [stable_Join_Always1]) 1);
qed "stable_Join_Always2";

Goal "[| F : stable A;  G : A ensures B |] ==> F Join G : A ensures B";
by (asm_simp_tac (simpset() addsimps [Join_ensures]) 1);
by (asm_full_simp_tac (simpset() addsimps [stable_def, ensures_def]) 1);
by (etac constrains_weaken 1);
by Auto_tac;
qed "stable_Join_ensures1";

(*As above, but exchanging the roles of F and G*)
Goal "[| F : A ensures B;  G : stable A |] ==> F Join G : A ensures B";
by (stac Join_commute 1);
by (blast_tac (claset() addIs [stable_Join_ensures1]) 1);
qed "stable_Join_ensures2";


(*** the ok and OK relations ***)

Goal "SKIP ok F";
by (auto_tac (claset(), simpset() addsimps [ok_def]));
qed "ok_SKIP1";  

Goal "F ok SKIP";
by (auto_tac (claset(), simpset() addsimps [ok_def]));
qed "ok_SKIP2";

AddIffs [ok_SKIP1, ok_SKIP2];  

Goal "(F ok G & (F Join G) ok H) = (G ok H & F ok (G Join H))";
by (auto_tac (claset(), simpset() addsimps [ok_def]));
qed "ok_Join_commute";

Goal "(F ok G) = (G ok F)";
by (auto_tac (claset(), simpset() addsimps [ok_def]));
qed "ok_commute";

bind_thm ("ok_sym", ok_commute RS iffD1);

Goal "OK {(#0::int,F),(#1,G),(#2,H)} snd = (F ok G & (F Join G) ok H)";
by (asm_full_simp_tac
    (simpset() addsimps [Ball_def, conj_disj_distribR, ok_def, Join_def, 
                   OK_def, insert_absorb, all_conj_distrib, eq_commute]) 1); 
by (Blast_tac 1); 
qed "ok_iff_OK";

Goal "F ok (G Join H) = (F ok G & F ok H)";
by (auto_tac (claset(), simpset() addsimps [ok_def]));
qed "ok_Join_iff1";

Goal "(G Join H) ok F = (G ok F & H ok F)";
by (auto_tac (claset(), simpset() addsimps [ok_def]));
qed "ok_Join_iff2";
AddIffs [ok_Join_iff1, ok_Join_iff2];

(*useful?  Not with the previous two around*)
Goal "[| F ok G; (F Join G) ok H |] ==> F ok (G Join H)";
by (auto_tac (claset(), simpset() addsimps [ok_def]));
qed "ok_Join_commute_I";

Goal "F ok (JOIN I G) = (ALL i:I. F ok G i)";
by (auto_tac (claset(), simpset() addsimps [ok_def]));
qed "ok_JN_iff1";

Goal "(JOIN I G) ok F =  (ALL i:I. G i ok F)";
by (auto_tac (claset(), simpset() addsimps [ok_def]));
qed "ok_JN_iff2";
AddIffs [ok_JN_iff1, ok_JN_iff2];

Goal "OK I F = (ALL i: I. ALL j: I-{i}. (F i) ok (F j))"; 
by (auto_tac (claset(), simpset() addsimps [ok_def, OK_def]));  
qed "OK_iff_ok";

Goal "[| OK I F; i: I; j: I; i ~= j|] ==> (F i) ok (F j)"; 
by (auto_tac (claset(), simpset() addsimps [OK_iff_ok]));  
qed "OK_imp_ok";


(*** Allowed ***)

Goal "Allowed SKIP = UNIV";
by (auto_tac (claset(), simpset() addsimps [Allowed_def]));  
qed "Allowed_SKIP";

Goal "Allowed (F Join G) = Allowed F Int Allowed G";
by (auto_tac (claset(), simpset() addsimps [Allowed_def]));  
qed "Allowed_Join";

Goal "Allowed (JOIN I F) = (INT i:I. Allowed (F i))";
by (auto_tac (claset(), simpset() addsimps [Allowed_def]));  
qed "Allowed_JN";

Addsimps [Allowed_SKIP, Allowed_Join, Allowed_JN];

Goal "F ok G = (F : Allowed G & G : Allowed F)";
by (simp_tac (simpset() addsimps [ok_def, Allowed_def]) 1);
qed "ok_iff_Allowed";

Goal "OK I F = (ALL i: I. ALL j: I-{i}. F i : Allowed(F j))"; 
by (auto_tac (claset(), simpset() addsimps [OK_iff_ok, ok_iff_Allowed]));  
qed "OK_iff_Allowed";

(*** safety_prop, for reasoning about given instances of "ok" ***)

Goal "safety_prop X ==> (Acts G <= insert Id (UNION X Acts)) = (G : X)";
by (auto_tac (claset(), simpset() addsimps [safety_prop_def]));
qed "safety_prop_Acts_iff";

Goal "safety_prop X ==> (UNION X Acts <= AllowedActs F) = (X <= Allowed F)";
by (auto_tac (claset(), 
      simpset() addsimps [Allowed_def, safety_prop_Acts_iff RS sym]));  
qed "safety_prop_AllowedActs_iff_Allowed";

Goal "safety_prop X ==> Allowed (mk_program (init, acts, UNION X Acts)) = X";
by (asm_simp_tac (simpset() addsimps [Allowed_def, safety_prop_Acts_iff]) 1); 
qed "Allowed_eq";

Goal "[| F == mk_program (init, acts, UNION X Acts) ; safety_prop X |] \
\     ==> Allowed F = X";
by (asm_simp_tac (simpset() addsimps [Allowed_eq]) 1); 
qed "def_prg_Allowed";

(*For safety_prop to hold, the property must be satisfiable!*)
Goal "safety_prop (A co B) = (A <= B)";
by (simp_tac (simpset() addsimps [safety_prop_def, constrains_def]) 1);
by (Blast_tac 1); 
qed "safety_prop_constrains";
AddIffs [safety_prop_constrains];

Goal "safety_prop (stable A)";
by (simp_tac (simpset() addsimps [stable_def]) 1);
qed "safety_prop_stable";
AddIffs [safety_prop_stable];

Goal "[| safety_prop X; safety_prop Y |] ==> safety_prop (X Int Y)";
by (full_simp_tac (simpset() addsimps [safety_prop_def]) 1); 
by (Blast_tac 1); 
qed "safety_prop_Int";
Addsimps [safety_prop_Int];

Goal "(ALL i. safety_prop (X i)) ==> safety_prop (INT i. X i)";
by (auto_tac (claset(), simpset() addsimps [safety_prop_def]));
by (Blast_tac 1); 
bind_thm ("safety_prop_INTER1", allI RS result());
Addsimps [safety_prop_INTER1];
							       
Goal "(ALL i:I. safety_prop (X i)) ==> safety_prop (INT i:I. X i)";
by (auto_tac (claset(), simpset() addsimps [safety_prop_def]));
by (Blast_tac 1); 
bind_thm ("safety_prop_INTER", ballI RS result());
Addsimps [safety_prop_INTER];

Goal "[| F == mk_program(init,acts,UNION X Acts); safety_prop X |] \
\     ==> F ok G = (G : X & acts <= AllowedActs G)";
by (auto_tac (claset(), simpset() addsimps [ok_def, safety_prop_Acts_iff]));  
qed "def_UNION_ok_iff";
