/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.Decls;
import kodkod.ast.Expression;
import kodkod.ast.Variable;
import kodkod.ast.operator.Multiplicity;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public final class Decl
extends Decls {
    private final Variable variable;
    private final Multiplicity mult;
    private final Expression expression;

    Decl(Variable variable, Multiplicity multiplicity, Expression expression) {
        if (multiplicity == Multiplicity.NO) {
            throw new IllegalArgumentException("NO is not a valid multiplicity in a declaration.");
        }
        if (variable.arity() != expression.arity()) {
            throw new IllegalArgumentException("Unmatched arities in a declaration: " + variable + " and " + expression);
        }
        if (multiplicity != Multiplicity.SET && expression.arity() > 1) {
            throw new IllegalArgumentException("Cannot use multiplicity " + (Object)((Object)multiplicity) + " with an expression of arity > 1.");
        }
        this.variable = variable;
        this.mult = multiplicity;
        this.expression = expression;
    }

    public Variable variable() {
        return this.variable;
    }

    public Multiplicity multiplicity() {
        return this.mult;
    }

    public Expression expression() {
        return this.expression;
    }

    @Override
    public <E, F, D, I> D accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return this.variable + ": " + (Object)((Object)this.mult) + " " + this.expression;
    }
}

