/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import java.util.Iterator;
import kodkod.ast.Formula;
import kodkod.ast.operator.FormulaOperator;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;
import kodkod.util.collections.Containers;

public final class NaryFormula
extends Formula
implements Iterable<Formula> {
    private final FormulaOperator op;
    private final Formula[] children;

    NaryFormula(FormulaOperator formulaOperator, Formula[] formulaArray) {
        assert (formulaArray.length > 2);
        if (!formulaOperator.nary()) {
            throw new IllegalArgumentException("Cannot construct an nary formula using the non-nary operator " + (Object)((Object)formulaOperator));
        }
        this.op = formulaOperator;
        this.children = formulaArray;
    }

    public FormulaOperator op() {
        return this.op;
    }

    public int size() {
        return this.children.length;
    }

    public Formula child(int n) {
        return this.children[n];
    }

    @Override
    public Iterator<Formula> iterator() {
        return Containers.iterate(this.children);
    }

    @Override
    public <E, F, D, I> F accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("(");
        stringBuilder.append(this.child(0));
        int n = this.size();
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(" ");
            stringBuilder.append((Object)this.op);
            stringBuilder.append(" ");
            stringBuilder.append(this.child(i));
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

