/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import java.util.Arrays;
import java.util.Iterator;
import kodkod.ast.Expression;
import kodkod.ast.IntExpression;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;
import kodkod.util.collections.Containers;

public final class ProjectExpression
extends Expression {
    private final Expression expr;
    private final IntExpression[] columns;

    ProjectExpression(Expression expression, IntExpression ... intExpressionArray) {
        if (intExpressionArray.length == 0) {
            throw new IllegalArgumentException("No columns specified for projection.");
        }
        this.expr = expression;
        this.columns = new IntExpression[intExpressionArray.length];
        System.arraycopy(intExpressionArray, 0, this.columns, 0, intExpressionArray.length);
    }

    @Override
    public int arity() {
        return this.columns.length;
    }

    public Expression expression() {
        return this.expr;
    }

    public Iterator<IntExpression> columns() {
        return Containers.iterate(this.columns);
    }

    public IntExpression column(int n) {
        return this.columns[n];
    }

    @Override
    public <E, F, D, I> E accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    @Override
    public String toString() {
        return this.expr.toString() + Arrays.toString(this.columns);
    }
}

