/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast;

import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.LeafExpression;
import kodkod.ast.RelationPredicate;
import kodkod.ast.operator.Multiplicity;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.ast.visitor.VoidVisitor;

public class Relation
extends LeafExpression {
    private Relation(String string, int n) {
        super(string, n);
    }

    public static Relation nary(String string, int n) {
        return new Relation(string, n);
    }

    public static Relation unary(String string) {
        return new Relation(string, 1);
    }

    public static Relation binary(String string) {
        return new Relation(string, 2);
    }

    public static Relation ternary(String string) {
        return new Relation(string, 3);
    }

    @Override
    public <E, F, D, I> E accept(ReturnVisitor<E, F, D, I> returnVisitor) {
        return returnVisitor.visit(this);
    }

    @Override
    public void accept(VoidVisitor voidVisitor) {
        voidVisitor.visit(this);
    }

    public Formula acyclic() {
        return new RelationPredicate.Acyclic(this);
    }

    public Formula function(Expression expression, Expression expression2) {
        return new RelationPredicate.Function(this, expression, Multiplicity.ONE, expression2);
    }

    public Formula partialFunction(Expression expression, Expression expression2) {
        return new RelationPredicate.Function(this, expression, Multiplicity.LONE, expression2);
    }

    public Formula totalOrder(Relation relation, Relation relation2, Relation relation3) {
        return new RelationPredicate.TotalOrdering(this, relation, relation2, relation3);
    }
}

