/*
 * Decompiled with CFR 0.152.
 */
package kodkod.ast.operator;

public enum IntOperator {
    PLUS{

        public String toString() {
            return "+";
        }
    }
    ,
    MULTIPLY{

        public String toString() {
            return "*";
        }
    }
    ,
    MINUS{

        public String toString() {
            return "-";
        }
    }
    ,
    DIVIDE{

        public String toString() {
            return "/";
        }
    }
    ,
    MODULO{

        public String toString() {
            return "%";
        }
    }
    ,
    AND{

        public String toString() {
            return "&";
        }
    }
    ,
    OR{

        public String toString() {
            return "|";
        }
    }
    ,
    XOR{

        public String toString() {
            return "^";
        }
    }
    ,
    SHL{

        public String toString() {
            return "<<";
        }
    }
    ,
    SHR{

        public String toString() {
            return ">>>";
        }
    }
    ,
    SHA{

        public String toString() {
            return ">>";
        }
    }
    ,
    NEG{

        public String toString() {
            return "-";
        }
    }
    ,
    NOT{

        public String toString() {
            return "~";
        }
    }
    ,
    ABS{

        public String toString() {
            return "abs";
        }
    }
    ,
    SGN{

        public String toString() {
            return "sgn";
        }
    };

    static final int unary;
    static final int binary;
    static final int nary;

    private final int index() {
        return 1 << this.ordinal();
    }

    public final boolean unary() {
        return (unary & this.index()) != 0;
    }

    public final boolean binary() {
        return (binary & this.index()) != 0;
    }

    public final boolean nary() {
        return (nary & this.index()) != 0;
    }

    static {
        unary = NEG.index() | NOT.index() | ABS.index() | SGN.index();
        binary = ~unary;
        nary = PLUS.index() | MULTIPLY.index() | AND.index() | OR.index();
    }
}

