/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine;

import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IntExpression;
import kodkod.engine.bool.BooleanMatrix;
import kodkod.engine.bool.Int;
import kodkod.engine.config.Options;
import kodkod.engine.fol2sat.Translator;
import kodkod.instance.Instance;
import kodkod.instance.TupleSet;

public final class Evaluator {
    private final Instance instance;
    private final Options options;

    public Evaluator(Instance instance) {
        this(instance, new Options());
    }

    public Evaluator(Instance instance, Options options) {
        if (instance == null || options == null) {
            throw new NullPointerException();
        }
        this.instance = instance;
        this.options = options;
    }

    public Options options() {
        return this.options;
    }

    public Instance instance() {
        return this.instance;
    }

    public boolean evaluate(Formula formula) {
        if (formula == null) {
            throw new NullPointerException("formula");
        }
        return Translator.evaluate(formula, this.instance, this.options).booleanValue();
    }

    public TupleSet evaluate(Expression expression) {
        if (expression == null) {
            throw new NullPointerException("expression");
        }
        BooleanMatrix booleanMatrix = Translator.evaluate(expression, this.instance, this.options);
        return this.instance.universe().factory().setOf(expression.arity(), booleanMatrix.denseIndices());
    }

    public int evaluate(IntExpression intExpression) {
        if (intExpression == null) {
            throw new NullPointerException("intexpression");
        }
        Int intVal = Translator.evaluate(intExpression, this.instance, this.options);
        return intVal.value();
    }

    public String toString() {
        return this.options + "\n" + this.instance;
    }
}

