/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.Formula;
import kodkod.ast.Node;
import kodkod.ast.Variable;
import kodkod.ast.visitor.AbstractVoidVisitor;
import kodkod.engine.Proof;
import kodkod.engine.fol2sat.RecordFilter;
import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.fol2sat.TranslationRecord;
import kodkod.engine.satlab.ReductionStrategy;
import kodkod.engine.satlab.SATProver;
import kodkod.engine.ucore.StrategyUtils;
import kodkod.instance.TupleSet;
import kodkod.util.collections.IdentityHashSet;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.IntTreeSet;

final class ResolutionBasedProof
extends Proof {
    private SATProver solver;
    private RecordFilter coreFilter;
    private Map<Formula, Node> coreRoots;

    ResolutionBasedProof(SATProver sATProver, TranslationLog translationLog) {
        super(translationLog);
        this.solver = sATProver;
        this.coreFilter = null;
        this.coreRoots = null;
    }

    private Set<Formula> connectedCore(final IntSet intSet) {
        final IdentityHashSet identityHashSet = new IdentityHashSet();
        RecordFilter recordFilter = new RecordFilter(){

            @Override
            public boolean accept(Node node, Formula formula, int n, Map<Variable, TupleSet> map) {
                return intSet.contains(StrictMath.abs(n));
            }
        };
        Object object = this.log().replay(recordFilter);
        while (object.hasNext()) {
            identityHashSet.add(object.next().translated());
        }
        object = new IdentityHashSet();
        AbstractVoidVisitor abstractVoidVisitor = new AbstractVoidVisitor((Set)object){
            final Set<Node> visited = new IdentityHashSet<Node>();
            final /* synthetic */ Set val$connected;
            {
                this.val$connected = set2;
            }

            @Override
            protected boolean visited(Node node) {
                if (this.visited.add(node) && identityHashSet.contains(node)) {
                    this.val$connected.add((Formula)node);
                    return false;
                }
                return true;
            }
        };
        for (Formula formula : this.log().roots()) {
            formula.accept(abstractVoidVisitor);
        }
        return object;
    }

    @Override
    public final Iterator<TranslationRecord> core() {
        if (this.coreFilter == null) {
            this.coreFilter = new RecordFilter(){
                final IntSet coreVariables;
                final Set<Formula> coreNodes;
                {
                    this.coreVariables = StrategyUtils.coreVars(ResolutionBasedProof.this.solver.proof());
                    this.coreNodes = ResolutionBasedProof.this.connectedCore(this.coreVariables);
                }

                @Override
                public boolean accept(Node node, Formula formula, int n, Map<Variable, TupleSet> map) {
                    return this.coreNodes.contains(formula) && this.coreVariables.contains(StrictMath.abs(n));
                }
            };
        }
        return this.log().replay(this.coreFilter);
    }

    @Override
    public final Map<Formula, Node> highLevelCore() {
        if (this.coreRoots == null) {
            RecordFilter recordFilter = new RecordFilter(){
                final IntSet coreUnits;
                final Set<Formula> roots;
                {
                    this.coreUnits = StrategyUtils.coreUnits(ResolutionBasedProof.this.solver.proof());
                    this.roots = ResolutionBasedProof.this.log().roots();
                }

                @Override
                public boolean accept(Node node, Formula formula, int n, Map<Variable, TupleSet> map) {
                    return this.roots.contains(formula) && this.coreUnits.contains(Math.abs(n));
                }
            };
            this.coreRoots = new LinkedHashMap<Formula, Node>();
            IntTreeSet intTreeSet = new IntTreeSet();
            Iterator<TranslationRecord> iterator = this.log().replay(recordFilter);
            while (iterator.hasNext()) {
                TranslationRecord translationRecord = iterator.next();
                if (!intTreeSet.add(translationRecord.literal())) continue;
                this.coreRoots.put(translationRecord.translated(), translationRecord.node());
            }
            this.coreRoots = Collections.unmodifiableMap(this.coreRoots);
        }
        return this.coreRoots;
    }

    @Override
    public void minimize(ReductionStrategy reductionStrategy) {
        this.solver.reduce(reductionStrategy);
        this.coreFilter = null;
        this.coreRoots = null;
    }
}

