/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.Operator;

public final class BooleanConstant
extends BooleanValue {
    final int label;
    public static final BooleanConstant TRUE = new BooleanConstant(true);
    public static final BooleanConstant FALSE = new BooleanConstant(false);

    private BooleanConstant(boolean bl) {
        this.label = bl ? Integer.MAX_VALUE : -2147483647;
    }

    @Override
    BooleanValue negation() {
        return this == TRUE ? FALSE : TRUE;
    }

    public boolean booleanValue() {
        return this.label > 0;
    }

    public static BooleanConstant constant(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    @Override
    public int label() {
        return this.label;
    }

    public String toString() {
        return this.label > 0 ? "T" : "F";
    }

    @Override
    public Operator op() {
        return Operator.CONST;
    }
}

