/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Iterator;
import java.util.Set;
import kodkod.engine.bool.BinaryGate;
import kodkod.engine.bool.BooleanAccumulator;
import kodkod.engine.bool.BooleanConstant;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.BooleanVariable;
import kodkod.engine.bool.ITEGate;
import kodkod.engine.bool.NaryGate;
import kodkod.engine.bool.Operator;
import kodkod.util.collections.CacheSet;
import kodkod.util.collections.IdentityHashSet;

final class CBCFactory {
    private final Set<BooleanFormula> scrap0;
    private final Set<BooleanFormula> scrap1;
    private final BooleanVariable[] vars;
    private final CacheSet<BooleanFormula>[] cache;
    private int label;
    private int cmpMax;
    private final Assembler JoX = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op().ordinal < 2);
            int n = booleanFormula2.label();
            if (booleanFormula.contains(booleanFormula.op(), n, CBCFactory.this.cmpMax) > 0) {
                return nary == booleanFormula.op() ? booleanFormula : booleanFormula2;
            }
            if (nary == booleanFormula.op() && booleanFormula.contains(nary, -n, CBCFactory.this.cmpMax) > 0) {
                return nary.shortCircuit();
            }
            return CBCFactory.this.cache(nary, booleanFormula, booleanFormula2);
        }
    };
    private final Assembler AoO = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op() == Operator.AND && booleanFormula2.op() == Operator.OR);
            CBCFactory.this.scrap0.clear();
            CBCFactory.this.scrap1.clear();
            booleanFormula.flatten(booleanFormula.op(), CBCFactory.this.scrap0, CBCFactory.this.cmpMax);
            booleanFormula2.flatten(booleanFormula2.op(), CBCFactory.this.scrap1, CBCFactory.this.cmpMax);
            for (BooleanFormula booleanFormula3 : CBCFactory.this.scrap1) {
                if (!CBCFactory.this.scrap0.contains(booleanFormula3)) continue;
                return nary == Operator.AND ? booleanFormula : booleanFormula2;
            }
            return booleanFormula.label() < booleanFormula2.label() ? CBCFactory.this.JoX.assemble(nary, booleanFormula2, booleanFormula) : CBCFactory.this.JoX.assemble(nary, booleanFormula, booleanFormula2);
        }
    };
    private final Assembler JoJ = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op() == booleanFormula2.op());
            if (booleanFormula == booleanFormula2) {
                return booleanFormula;
            }
            Operator operator = booleanFormula.op();
            CBCFactory.this.scrap0.clear();
            CBCFactory.this.scrap1.clear();
            booleanFormula.flatten(operator, CBCFactory.this.scrap0, CBCFactory.this.cmpMax);
            booleanFormula2.flatten(operator, CBCFactory.this.scrap1, CBCFactory.this.cmpMax);
            if (CBCFactory.this.scrap0.size() < CBCFactory.this.scrap1.size() && CBCFactory.this.scrap1.containsAll(CBCFactory.this.scrap0)) {
                return nary == operator ? booleanFormula2 : booleanFormula;
            }
            if (CBCFactory.this.scrap0.size() >= CBCFactory.this.scrap1.size() && CBCFactory.this.scrap0.containsAll(CBCFactory.this.scrap1)) {
                return nary == operator ? booleanFormula : booleanFormula2;
            }
            if (booleanFormula.label() < booleanFormula2.label()) {
                return CBCFactory.this.JoX.assemble(nary, booleanFormula2, booleanFormula);
            }
            return CBCFactory.this.JoX.assemble(nary, booleanFormula, booleanFormula2);
        }
    };
    private final Assembler JoI = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op().ordinal < 2 && booleanFormula2.op() == Operator.ITE);
            if (booleanFormula.label() < booleanFormula2.label()) {
                return CBCFactory.this.cache(nary, booleanFormula2, booleanFormula);
            }
            return CBCFactory.this.JoX.assemble(nary, booleanFormula, booleanFormula2);
        }
    };
    private final Assembler JoN = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op().ordinal < 2 && booleanFormula2.op() == Operator.NOT);
            if (booleanFormula.label() == -booleanFormula2.label()) {
                return nary.shortCircuit();
            }
            if (booleanFormula.label() < StrictMath.abs(booleanFormula2.label())) {
                return CBCFactory.this.NoX.assemble(nary, booleanFormula2, booleanFormula);
            }
            return CBCFactory.this.JoX.assemble(nary, booleanFormula, booleanFormula2);
        }
    };
    private final Assembler IoV = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op() == Operator.ITE && booleanFormula2.op() == Operator.VAR);
            return CBCFactory.this.cache(nary, booleanFormula, booleanFormula2);
        }
    };
    private final Assembler IoN = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op() == Operator.ITE && booleanFormula2.op() == Operator.NOT);
            if (booleanFormula.label() == -booleanFormula2.label()) {
                return nary.shortCircuit();
            }
            if (booleanFormula.label() < StrictMath.abs(booleanFormula2.label())) {
                return CBCFactory.this.NoX.assemble(nary, booleanFormula2, booleanFormula);
            }
            return CBCFactory.this.cache(nary, booleanFormula, booleanFormula2);
        }
    };
    private final Assembler NoX = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op() == Operator.NOT);
            int n = booleanFormula2.label();
            if (booleanFormula.input(0).contains(nary.complement(), n, CBCFactory.this.cmpMax) > 0) {
                return nary.shortCircuit();
            }
            if (booleanFormula.input(0).contains(nary.complement(), -n, CBCFactory.this.cmpMax) > 0) {
                return booleanFormula;
            }
            return CBCFactory.this.cache(nary, booleanFormula, booleanFormula2);
        }
    };
    private final Assembler NoN = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op() == Operator.NOT && booleanFormula2.op() == Operator.NOT);
            if (booleanFormula == booleanFormula2) {
                return booleanFormula;
            }
            if (booleanFormula.label() < booleanFormula2.label()) {
                return CBCFactory.this.NoX.assemble(nary, booleanFormula, booleanFormula2);
            }
            return CBCFactory.this.NoX.assemble(nary, booleanFormula2, booleanFormula);
        }
    };
    private final Assembler NoV = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op() == Operator.NOT && booleanFormula2.op() == Operator.VAR);
            if (booleanFormula.label() == -booleanFormula2.label()) {
                return nary.shortCircuit();
            }
            return CBCFactory.this.NoX.assemble(nary, booleanFormula, booleanFormula2);
        }
    };
    private final Assembler XoX = new Assembler(){

        @Override
        BooleanValue assemble(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
            assert (booleanFormula.op() == booleanFormula2.op());
            return booleanFormula == booleanFormula2 ? booleanFormula : CBCFactory.this.cache(nary, booleanFormula, booleanFormula2);
        }
    };
    private final Assembler[] ASSEMBLERS = new Assembler[]{this.JoJ, this.AoO, this.JoI, this.JoN, this.JoX, this.JoJ, this.JoI, this.JoN, this.JoX, this.XoX, this.IoN, this.IoV, this.NoN, this.NoV, this.XoX};

    CBCFactory(int n, int n2) {
        assert (n2 > 0 && n >= 0);
        this.cmpMax = n2;
        this.label = n + 1;
        this.vars = new BooleanVariable[n];
        for (int i = 0; i < n; ++i) {
            this.vars[i] = new BooleanVariable(i + 1);
        }
        this.scrap0 = new IdentityHashSet<BooleanFormula>(n2);
        this.scrap1 = new IdentityHashSet<BooleanFormula>(n2);
        this.cache = new CacheSet[]{new CacheSet(), new CacheSet(), new CacheSet()};
    }

    private CacheSet<BooleanFormula> opCache(Operator operator) {
        return this.cache[operator.ordinal];
    }

    void setCmpMax(int n) {
        assert (n > 0);
        this.cmpMax = n;
    }

    int cmpMax() {
        return this.cmpMax;
    }

    void clear() {
        this.label = this.vars.length + 1;
        this.cache[0].clear();
        this.cache[1].clear();
        this.cache[2].clear();
        this.scrap0.clear();
        this.scrap1.clear();
    }

    boolean canAssemble(BooleanValue booleanValue) {
        int n;
        if (booleanValue.op() == Operator.CONST) {
            return true;
        }
        if (booleanValue.label() < 0) {
            booleanValue = booleanValue.negation();
        }
        if ((n = booleanValue.label()) <= this.vars.length) {
            return booleanValue == this.vars[n - 1];
        }
        BooleanFormula booleanFormula = (BooleanFormula)booleanValue;
        Iterator<BooleanFormula> iterator = this.opCache(booleanFormula.op()).get(booleanFormula.hashCode());
        while (iterator.hasNext()) {
            if (iterator.next() != booleanFormula) continue;
            return true;
        }
        return false;
    }

    int numVars() {
        return this.vars.length;
    }

    BooleanVariable variable(int n) {
        return this.vars[n - 1];
    }

    BooleanValue assemble(BooleanValue booleanValue, BooleanValue booleanValue2, BooleanValue booleanValue3) {
        if (booleanValue == BooleanConstant.TRUE || booleanValue2 == booleanValue3) {
            return booleanValue2;
        }
        if (booleanValue == BooleanConstant.FALSE) {
            return booleanValue3;
        }
        if (booleanValue2 == BooleanConstant.TRUE || booleanValue == booleanValue2) {
            return this.assemble(Operator.OR, booleanValue, booleanValue3);
        }
        if (booleanValue2 == BooleanConstant.FALSE || booleanValue.label() == -booleanValue2.label()) {
            return this.assemble(Operator.AND, booleanValue.negation(), booleanValue3);
        }
        if (booleanValue3 == BooleanConstant.TRUE || booleanValue.label() == -booleanValue3.label()) {
            return this.assemble(Operator.OR, booleanValue.negation(), booleanValue2);
        }
        if (booleanValue3 == BooleanConstant.FALSE || booleanValue == booleanValue3) {
            return this.assemble(Operator.AND, booleanValue, booleanValue2);
        }
        BooleanFormula booleanFormula = (BooleanFormula)booleanValue;
        BooleanFormula booleanFormula2 = (BooleanFormula)booleanValue2;
        BooleanFormula booleanFormula3 = (BooleanFormula)booleanValue3;
        int n = Operator.ITE.hash(booleanFormula, booleanFormula2, booleanFormula3);
        Object object = this.opCache(Operator.ITE).get(n);
        while (object.hasNext()) {
            BooleanFormula booleanFormula4 = object.next();
            if (booleanFormula4.input(0) != booleanValue || booleanFormula4.input(1) != booleanValue2 || booleanFormula4.input(2) != booleanValue3) continue;
            return booleanFormula4;
        }
        object = new ITEGate(this.label++, n, booleanFormula, booleanFormula2, booleanFormula3);
        this.opCache(Operator.ITE).add((BooleanFormula)object);
        return object;
    }

    BooleanValue assemble(Operator.Nary nary, BooleanValue booleanValue, BooleanValue booleanValue2) {
        BooleanValue booleanValue3;
        BooleanValue booleanValue4;
        if (booleanValue.op().ordinal < booleanValue2.op().ordinal) {
            booleanValue4 = booleanValue;
            booleanValue3 = booleanValue2;
        } else {
            booleanValue4 = booleanValue2;
            booleanValue3 = booleanValue;
        }
        if (booleanValue3.op() == Operator.CONST) {
            return booleanValue3 == nary.identity() ? booleanValue4 : booleanValue3;
        }
        return this.assembler(booleanValue4.op(), booleanValue3.op()).assemble(nary, (BooleanFormula)booleanValue4, (BooleanFormula)booleanValue3);
    }

    BooleanValue assemble(BooleanAccumulator booleanAccumulator) {
        Object object;
        int n = booleanAccumulator.size();
        Operator.Nary nary = booleanAccumulator.op;
        switch (n) {
            case 0: {
                return nary.identity();
            }
            case 1: {
                return booleanAccumulator.iterator().next();
            }
            case 2: {
                Iterator<BooleanValue> iterator = booleanAccumulator.iterator();
                return this.assemble(nary, iterator.next(), iterator.next());
            }
        }
        int n2 = nary.hash(booleanAccumulator.iterator());
        if (n > this.cmpMax) {
            object = this.opCache(nary).get(n2);
            while (object.hasNext()) {
                BooleanFormula booleanFormula = object.next();
                if (booleanFormula.size() != n || !((NaryGate)booleanFormula).sameInputs(booleanAccumulator.iterator())) continue;
                return booleanFormula;
            }
        } else {
            object = this.opCache(nary).get(n2);
            block6: while (object.hasNext()) {
                BooleanFormula booleanFormula = object.next();
                if (booleanFormula.size() == n && ((NaryGate)booleanFormula).sameInputs(booleanAccumulator.iterator())) {
                    return booleanFormula;
                }
                if (booleanFormula.size() >= n) continue;
                this.scrap0.clear();
                booleanFormula.flatten(nary, this.scrap0, this.cmpMax);
                if (this.scrap0.size() != n) continue;
                for (BooleanValue booleanValue : booleanAccumulator) {
                    if (this.scrap0.contains(booleanValue)) continue;
                    continue block6;
                }
                return booleanFormula;
            }
        }
        object = new NaryGate(booleanAccumulator, this.label++, n2);
        this.opCache(booleanAccumulator.op).add((BooleanFormula)object);
        return object;
    }

    private Assembler assembler(Operator operator, Operator operator2) {
        return this.ASSEMBLERS[(operator.ordinal << 2) + operator2.ordinal - (operator.ordinal * (operator.ordinal - 1) >> 1)];
    }

    private BooleanFormula cache(Operator.Nary nary, BooleanFormula booleanFormula, BooleanFormula booleanFormula2) {
        Iterator<BooleanFormula> iterator;
        BooleanFormula booleanFormula3;
        BooleanFormula booleanFormula4;
        if (booleanFormula.label() < booleanFormula2.label()) {
            booleanFormula4 = booleanFormula;
            booleanFormula3 = booleanFormula2;
        } else {
            booleanFormula4 = booleanFormula2;
            booleanFormula3 = booleanFormula;
        }
        int n = nary.hash(booleanFormula4, booleanFormula3);
        if (booleanFormula4.op() == nary || booleanFormula3.op() == nary) {
            this.scrap0.clear();
            booleanFormula4.flatten(nary, this.scrap0, this.cmpMax - 1);
            booleanFormula3.flatten(nary, this.scrap0, this.cmpMax - this.scrap0.size());
            iterator = this.opCache(nary).get(n);
            while (iterator.hasNext()) {
                BooleanFormula booleanFormula5 = iterator.next();
                if (booleanFormula5.size() == 2 && booleanFormula5.input(0) == booleanFormula4 && booleanFormula5.input(1) == booleanFormula3) {
                    return booleanFormula5;
                }
                this.scrap1.clear();
                booleanFormula5.flatten(nary, this.scrap1, this.cmpMax);
                if (!((Object)this.scrap0).equals(this.scrap1)) continue;
                return booleanFormula5;
            }
        } else {
            iterator = this.opCache(nary).get(n);
            while (iterator.hasNext()) {
                BooleanFormula booleanFormula6 = iterator.next();
                if (booleanFormula6.size() != 2 || booleanFormula6.input(0) != booleanFormula4 || booleanFormula6.input(1) != booleanFormula3) continue;
                return booleanFormula6;
            }
        }
        iterator = new BinaryGate(nary, this.label++, n, booleanFormula4, booleanFormula3);
        this.opCache(nary).add((BooleanFormula)((Object)iterator));
        return iterator;
    }

    private static abstract class Assembler {
        private Assembler() {
        }

        abstract BooleanValue assemble(Operator.Nary var1, BooleanFormula var2, BooleanFormula var3);
    }
}

