/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.bool;

import java.util.Iterator;
import java.util.Set;
import kodkod.engine.bool.BooleanAccumulator;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.MultiGate;
import kodkod.engine.bool.Operator;
import kodkod.util.collections.Containers;

final class NaryGate
extends MultiGate {
    private final BooleanFormula[] inputs;

    NaryGate(BooleanAccumulator booleanAccumulator, int n, int n2) {
        super(booleanAccumulator.op, n, n2);
        this.inputs = new BooleanFormula[booleanAccumulator.size()];
        int n3 = 0;
        Iterator<BooleanValue> iterator = booleanAccumulator.iterator();
        while (iterator.hasNext()) {
            this.inputs[n3] = (BooleanFormula)iterator.next();
            ++n3;
        }
    }

    @Override
    public int size() {
        return this.inputs.length;
    }

    @Override
    public Iterator<BooleanFormula> iterator() {
        return Containers.iterate(this.inputs);
    }

    @Override
    int contains(Operator operator, int n, int n2) {
        int n3;
        assert (n2 > 0);
        if (n == this.label()) {
            return 1;
        }
        if (this.op != operator || n > this.label() || -n > this.label()) {
            return -1;
        }
        int n4 = 0;
        int n5 = this.inputs.length - 1;
        for (n3 = 1; n4 <= n5 && n3 <= n2; ++n3) {
            int n6 = n4 + n5 >>> 1;
            int n7 = this.inputs[n6].label();
            if (n7 < n) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n) {
                n5 = n6 - 1;
                continue;
            }
            return n3;
        }
        return 1 - n3;
    }

    @Override
    void flatten(Operator operator, Set<BooleanFormula> set, int n) {
        assert (n > 0);
        if (this.op == operator && n >= this.inputs.length) {
            int n2 = n - this.inputs.length;
            for (BooleanFormula booleanFormula : this.inputs) {
                int n3 = set.size();
                booleanFormula.flatten(operator, set, StrictMath.max(1, n2));
                n2 -= set.size() - n3;
            }
        } else {
            set.add(this);
        }
    }

    boolean sameInputs(Iterator<? extends BooleanValue> iterator) {
        for (BooleanFormula booleanFormula : this.inputs) {
            if (iterator.hasNext() && booleanFormula == iterator.next()) continue;
            return false;
        }
        return !iterator.hasNext();
    }

    @Override
    public BooleanFormula input(int n) {
        if (n < 0 || n > this.inputs.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.inputs[n];
    }
}

