/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.config;

import kodkod.engine.config.AbstractReporter;
import kodkod.engine.config.Reporter;
import kodkod.engine.satlab.SATFactory;
import kodkod.util.ints.IntRange;
import kodkod.util.ints.Ints;

public final class Options {
    private Reporter reporter = new AbstractReporter(){};
    private SATFactory solver = SATFactory.DefaultSAT4J;
    private int symmetryBreaking = 20;
    private IntEncoding intEncoding = IntEncoding.TWOSCOMPLEMENT;
    private int bitwidth = 4;
    private int sharing = 3;
    private int skolemDepth = 0;
    private boolean flatten = false;
    private int logTranslation = 0;
    private int coreGranularity = 0;

    public SATFactory solver() {
        return this.solver;
    }

    public void setSolver(SATFactory sATFactory) {
        if (sATFactory == null) {
            throw new NullPointerException();
        }
        this.solver = sATFactory;
    }

    public Reporter reporter() {
        return this.reporter;
    }

    public void setReporter(Reporter reporter) {
        if (reporter == null) {
            throw new NullPointerException();
        }
        this.reporter = reporter;
    }

    private void checkRange(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new IllegalArgumentException(n + " !in [" + n2 + ".." + n3 + "]");
        }
    }

    public IntEncoding intEncoding() {
        return this.intEncoding;
    }

    public void setIntEncoding(IntEncoding intEncoding) {
        if (intEncoding.maxAllowedBitwidth() < this.bitwidth) {
            throw new IllegalArgumentException();
        }
        this.intEncoding = intEncoding;
    }

    public int bitwidth() {
        return this.bitwidth;
    }

    public void setBitwidth(int n) {
        this.checkRange(n, 1, this.intEncoding.maxAllowedBitwidth());
        this.bitwidth = n;
    }

    public IntRange integers() {
        return this.intEncoding.range(this.bitwidth);
    }

    public boolean flatten() {
        return this.flatten;
    }

    public void setFlatten(boolean bl) {
        if (this.logTranslation > 0 && bl) {
            throw new IllegalStateException("logTranslation enabled:  flattening must be off.");
        }
        this.flatten = bl;
    }

    public int symmetryBreaking() {
        return this.symmetryBreaking;
    }

    public void setSymmetryBreaking(int n) {
        this.checkRange(n, 0, Integer.MAX_VALUE);
        this.symmetryBreaking = n;
    }

    public int sharing() {
        return this.sharing;
    }

    public void setSharing(int n) {
        this.checkRange(n, 1, Integer.MAX_VALUE);
        this.sharing = n;
    }

    public int skolemDepth() {
        return this.skolemDepth;
    }

    public void setSkolemDepth(int n) {
        this.skolemDepth = n;
    }

    public int logTranslation() {
        return this.logTranslation;
    }

    public void setLogTranslation(int n) {
        this.checkRange(n, 0, 2);
        if (n > 0) {
            this.flatten = false;
        }
        this.logTranslation = n;
    }

    public int coreGranularity() {
        return this.coreGranularity;
    }

    public void setCoreGranularity(int n) {
        this.checkRange(n, 0, 3);
        this.coreGranularity = n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Options:");
        stringBuilder.append("\n solver: ");
        stringBuilder.append(this.solver);
        stringBuilder.append("\n reporter: ");
        stringBuilder.append(this.reporter);
        stringBuilder.append("\n intEncoding: ");
        stringBuilder.append((Object)this.intEncoding);
        stringBuilder.append("\n bitwidth: ");
        stringBuilder.append(this.bitwidth);
        stringBuilder.append("\n sharing: ");
        stringBuilder.append(this.sharing);
        stringBuilder.append("\n flatten: ");
        stringBuilder.append(this.flatten);
        stringBuilder.append("\n symmetryBreaking: ");
        stringBuilder.append(this.symmetryBreaking);
        stringBuilder.append("\n skolemDepth: ");
        stringBuilder.append(this.skolemDepth);
        stringBuilder.append("\n logTranslation: ");
        stringBuilder.append(this.logTranslation);
        stringBuilder.append("\n coreGranularity: ");
        stringBuilder.append(this.coreGranularity);
        return stringBuilder.toString();
    }

    public static enum IntEncoding {
        TWOSCOMPLEMENT{

            @Override
            int maxAllowedBitwidth() {
                return 32;
            }

            @Override
            IntRange range(int n) {
                int n2 = n - 1;
                return Ints.range(-1 << n2, (1 << n2) - 1);
            }
        };


        abstract int maxAllowedBitwidth();

        abstract IntRange range(int var1);
    }
}

