/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import kodkod.ast.Variable;

final class Environment<T> {
    private final Variable variable;
    private final T value;
    private final Environment<T> parent;
    static final Environment EMPTY = new Environment();

    private Environment() {
        this.variable = null;
        this.value = null;
        this.parent = this;
    }

    private Environment(Environment<T> environment, Variable variable, T t) {
        this.variable = variable;
        this.value = t;
        this.parent = environment;
    }

    public static <T> Environment<T> empty() {
        return EMPTY;
    }

    public Environment<T> parent() {
        return this.parent;
    }

    public Environment<T> extend(Variable variable, T t) {
        assert (variable != null);
        return new Environment<T>(this, variable, t);
    }

    public Variable variable() {
        return this.variable;
    }

    public T value() {
        return this.value;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public T lookup(Variable variable) {
        Environment<T> environment = this;
        while (environment != EMPTY && environment.variable != variable) {
            environment = environment.parent;
        }
        return environment.value;
    }

    public String toString() {
        return (this.parent == EMPTY ? "[]" : this.parent.toString()) + "[" + this.variable + "=" + this.value + "]";
    }
}

