/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.ArrayList;
import java.util.List;
import kodkod.ast.BinaryExpression;
import kodkod.ast.BinaryFormula;
import kodkod.ast.BinaryIntExpression;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.Comprehension;
import kodkod.ast.ConstantExpression;
import kodkod.ast.ConstantFormula;
import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.ExprToIntCast;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IfExpression;
import kodkod.ast.IfIntExpression;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.IntConstant;
import kodkod.ast.IntExpression;
import kodkod.ast.IntToExprCast;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryExpression;
import kodkod.ast.NaryFormula;
import kodkod.ast.NaryIntExpression;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.ProjectExpression;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.Relation;
import kodkod.ast.RelationPredicate;
import kodkod.ast.SumExpression;
import kodkod.ast.UnaryExpression;
import kodkod.ast.UnaryIntExpression;
import kodkod.ast.Variable;
import kodkod.ast.operator.ExprCompOperator;
import kodkod.ast.operator.ExprOperator;
import kodkod.ast.operator.FormulaOperator;
import kodkod.ast.operator.Multiplicity;
import kodkod.ast.operator.Quantifier;
import kodkod.ast.visitor.ReturnVisitor;
import kodkod.engine.bool.BooleanAccumulator;
import kodkod.engine.bool.BooleanConstant;
import kodkod.engine.bool.BooleanFactory;
import kodkod.engine.bool.BooleanMatrix;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.Dimensions;
import kodkod.engine.bool.Int;
import kodkod.engine.bool.Operator;
import kodkod.engine.fol2sat.Environment;
import kodkod.engine.fol2sat.FOL2BoolCache;
import kodkod.engine.fol2sat.HigherOrderDeclException;
import kodkod.engine.fol2sat.LeafInterpreter;
import kodkod.engine.fol2sat.TranslationLogger;
import kodkod.engine.fol2sat.UnboundLeafException;
import kodkod.util.ints.IndexedEntry;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.nodes.AnnotatedNode;
import kodkod.util.nodes.Nodes;

abstract class FOL2BoolTranslator
implements ReturnVisitor<BooleanMatrix, BooleanValue, Object, Int> {
    private final LeafInterpreter interpreter;
    private Environment<BooleanMatrix> env;
    private final FOL2BoolCache cache;

    static final <T> T translate(AnnotatedNode<? extends Node> annotatedNode, LeafInterpreter leafInterpreter) {
        FOL2BoolCache fOL2BoolCache = new FOL2BoolCache(annotatedNode);
        FOL2BoolTranslator fOL2BoolTranslator = new FOL2BoolTranslator(fOL2BoolCache, leafInterpreter){};
        return (T)annotatedNode.node().accept(fOL2BoolTranslator);
    }

    static final BooleanAccumulator translate(AnnotatedNode<Formula> annotatedNode, LeafInterpreter leafInterpreter, final TranslationLogger translationLogger) {
        FOL2BoolCache fOL2BoolCache = new FOL2BoolCache(annotatedNode);
        FOL2BoolTranslator fOL2BoolTranslator = new FOL2BoolTranslator(fOL2BoolCache, leafInterpreter){

            @Override
            BooleanValue cache(Formula formula, BooleanValue booleanValue) {
                translationLogger.log(formula, booleanValue, ((FOL2BoolTranslator)this).env);
                return super.cache(formula, booleanValue);
            }
        };
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND);
        for (Formula formula : Nodes.conjuncts(annotatedNode.node())) {
            booleanAccumulator.add(formula.accept(fOL2BoolTranslator));
        }
        translationLogger.close();
        return booleanAccumulator;
    }

    static final BooleanMatrix approximate(AnnotatedNode<Expression> annotatedNode, LeafInterpreter leafInterpreter, Environment<BooleanMatrix> environment) {
        FOL2BoolTranslator fOL2BoolTranslator = new FOL2BoolTranslator(new FOL2BoolCache(annotatedNode), leafInterpreter, (Environment)environment){

            @Override
            public final BooleanMatrix visit(BinaryExpression binaryExpression) {
                BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(binaryExpression);
                if (booleanMatrix != null) {
                    return booleanMatrix;
                }
                switch (binaryExpression.op()) {
                    case DIFFERENCE: {
                        return this.cache(binaryExpression, binaryExpression.left().accept(this));
                    }
                    case OVERRIDE: {
                        return this.cache(binaryExpression, binaryExpression.left().accept(this).or(binaryExpression.right().accept(this)));
                    }
                }
                return super.visit(binaryExpression);
            }

            @Override
            public final BooleanMatrix visit(Comprehension comprehension) {
                BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(comprehension);
                return booleanMatrix != null ? booleanMatrix : this.cache(comprehension, super.visit((Comprehension)Formula.TRUE.comprehension(comprehension.decls())));
            }

            @Override
            public BooleanMatrix visit(IfExpression ifExpression) {
                BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(ifExpression);
                return booleanMatrix != null ? booleanMatrix : this.cache(ifExpression, ifExpression.thenExpr().accept(this).or(ifExpression.elseExpr().accept(this)));
            }

            @Override
            public BooleanMatrix visit(IntToExprCast intToExprCast) {
                BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(intToExprCast);
                if (booleanMatrix != null) {
                    return booleanMatrix;
                }
                switch (intToExprCast.op()) {
                    case INTCAST: {
                        return this.cache(intToExprCast, Expression.INTS.accept(this));
                    }
                    case BITSETCAST: {
                        BooleanFactory booleanFactory = ((FOL2BoolTranslator)this).interpreter.factory();
                        booleanMatrix = booleanFactory.matrix(Dimensions.square(((FOL2BoolTranslator)this).interpreter.universe().size(), 1));
                        IntSet intSet = ((FOL2BoolTranslator)this).interpreter.ints();
                        int n = booleanFactory.bitwidth() - 1;
                        for (int i = 0; i < n; ++i) {
                            int n2 = 1 << i;
                            if (!intSet.contains(n2)) continue;
                            booleanMatrix.set(((FOL2BoolTranslator)this).interpreter.interpret(n2), BooleanConstant.TRUE);
                        }
                        if (intSet.contains(-1 << n)) {
                            booleanMatrix.set(((FOL2BoolTranslator)this).interpreter.interpret(-1 << n), BooleanConstant.TRUE);
                        }
                        return this.cache(intToExprCast, booleanMatrix);
                    }
                }
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)intToExprCast.op()));
            }
        };
        return annotatedNode.node().accept(fOL2BoolTranslator);
    }

    private FOL2BoolTranslator(FOL2BoolCache fOL2BoolCache, LeafInterpreter leafInterpreter) {
        this.interpreter = leafInterpreter;
        this.env = Environment.empty();
        this.cache = fOL2BoolCache;
    }

    private FOL2BoolTranslator(FOL2BoolCache fOL2BoolCache, LeafInterpreter leafInterpreter, Environment<BooleanMatrix> environment) {
        this.interpreter = leafInterpreter;
        this.env = environment;
        this.cache = fOL2BoolCache;
    }

    final <T> T lookup(Node node) {
        return this.cache.lookup(node, this.env);
    }

    final <T> T cache(Node node, T t) {
        return this.cache.cache(node, t, this.env);
    }

    BooleanValue cache(Formula formula, BooleanValue booleanValue) {
        return this.cache.cache(formula, booleanValue, this.env);
    }

    @Override
    public final List<BooleanMatrix> visit(Decls decls) {
        ArrayList<BooleanMatrix> arrayList = (ArrayList<BooleanMatrix>)this.lookup(decls);
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayList<BooleanMatrix>(decls.size());
        for (Decl decl : decls) {
            arrayList.add(this.visit(decl));
        }
        return this.cache(decls, arrayList);
    }

    @Override
    public final BooleanMatrix visit(Decl decl) {
        BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(decl);
        if (booleanMatrix != null) {
            return booleanMatrix;
        }
        if (decl.multiplicity() != Multiplicity.ONE) {
            throw new HigherOrderDeclException(decl);
        }
        return this.cache(decl, decl.expression().accept(this));
    }

    @Override
    public final BooleanMatrix visit(Variable variable) {
        BooleanMatrix booleanMatrix = this.env.lookup(variable);
        if (booleanMatrix != null) {
            return booleanMatrix;
        }
        throw new UnboundLeafException("Unbound variable", variable);
    }

    @Override
    public final BooleanMatrix visit(Relation relation) {
        return this.interpreter.interpret(relation);
    }

    @Override
    public final BooleanMatrix visit(ConstantExpression constantExpression) {
        return this.interpreter.interpret(constantExpression);
    }

    @Override
    public BooleanMatrix visit(BinaryExpression binaryExpression) {
        BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(binaryExpression);
        if (booleanMatrix != null) {
            return booleanMatrix;
        }
        BooleanMatrix booleanMatrix2 = binaryExpression.left().accept(this);
        BooleanMatrix booleanMatrix3 = binaryExpression.right().accept(this);
        ExprOperator exprOperator = binaryExpression.op();
        switch (exprOperator) {
            case UNION: {
                booleanMatrix = booleanMatrix2.or(booleanMatrix3);
                break;
            }
            case INTERSECTION: {
                booleanMatrix = booleanMatrix2.and(booleanMatrix3);
                break;
            }
            case DIFFERENCE: {
                booleanMatrix = booleanMatrix2.difference(booleanMatrix3);
                break;
            }
            case OVERRIDE: {
                booleanMatrix = booleanMatrix2.override(booleanMatrix3);
                break;
            }
            case JOIN: {
                booleanMatrix = booleanMatrix2.dot(booleanMatrix3);
                break;
            }
            case PRODUCT: {
                booleanMatrix = booleanMatrix2.cross(booleanMatrix3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)exprOperator));
            }
        }
        return this.cache(binaryExpression, booleanMatrix);
    }

    @Override
    public BooleanMatrix visit(NaryExpression naryExpression) {
        BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(naryExpression);
        if (booleanMatrix != null) {
            return booleanMatrix;
        }
        ExprOperator exprOperator = naryExpression.op();
        BooleanMatrix booleanMatrix2 = naryExpression.child(0).accept(this);
        BooleanMatrix[] booleanMatrixArray = new BooleanMatrix[naryExpression.size() - 1];
        for (int i = 0; i < booleanMatrixArray.length; ++i) {
            booleanMatrixArray[i] = naryExpression.child(i + 1).accept(this);
        }
        switch (exprOperator) {
            case UNION: {
                booleanMatrix = booleanMatrix2.or(booleanMatrixArray);
                break;
            }
            case INTERSECTION: {
                booleanMatrix = booleanMatrix2.and(booleanMatrixArray);
                break;
            }
            case OVERRIDE: {
                booleanMatrix = booleanMatrix2.override(booleanMatrixArray);
                break;
            }
            case PRODUCT: {
                booleanMatrix = booleanMatrix2.cross(booleanMatrixArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown associative operator: " + (Object)((Object)exprOperator));
            }
        }
        return this.cache(naryExpression, booleanMatrix);
    }

    @Override
    public final BooleanMatrix visit(UnaryExpression unaryExpression) {
        BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(unaryExpression);
        if (booleanMatrix != null) {
            return booleanMatrix;
        }
        BooleanMatrix booleanMatrix2 = unaryExpression.expression().accept(this);
        ExprOperator exprOperator = unaryExpression.op();
        switch (exprOperator) {
            case TRANSPOSE: {
                booleanMatrix = booleanMatrix2.transpose();
                break;
            }
            case CLOSURE: {
                booleanMatrix = booleanMatrix2.closure();
                break;
            }
            case REFLEXIVE_CLOSURE: {
                booleanMatrix = booleanMatrix2.closure().or(this.visit((ConstantExpression)Expression.IDEN));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)exprOperator));
            }
        }
        return this.cache(unaryExpression, booleanMatrix);
    }

    private final void comprehension(Decls decls, Formula formula, int n, BooleanValue booleanValue, int n2, BooleanMatrix booleanMatrix) {
        BooleanFactory booleanFactory = this.interpreter.factory();
        if (n == decls.size()) {
            booleanMatrix.set(n2, booleanFactory.and(booleanValue, formula.accept(this)));
            return;
        }
        Decl decl = decls.get(n);
        BooleanMatrix booleanMatrix2 = this.visit(decl);
        int n3 = (int)StrictMath.pow(this.interpreter.universe().size(), decls.size() - n - 1);
        BooleanMatrix booleanMatrix3 = booleanFactory.matrix(booleanMatrix2.dimensions());
        this.env = this.env.extend(decl.variable(), booleanMatrix3);
        for (IndexedEntry<BooleanValue> indexedEntry : booleanMatrix2) {
            booleanMatrix3.set(indexedEntry.index(), BooleanConstant.TRUE);
            this.comprehension(decls, formula, n + 1, booleanFactory.and(indexedEntry.value(), booleanValue), n2 + indexedEntry.index() * n3, booleanMatrix);
            booleanMatrix3.set(indexedEntry.index(), BooleanConstant.FALSE);
        }
        this.env = this.env.parent();
    }

    @Override
    public BooleanMatrix visit(Comprehension comprehension) {
        BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(comprehension);
        if (booleanMatrix != null) {
            return booleanMatrix;
        }
        booleanMatrix = this.interpreter.factory().matrix(Dimensions.square(this.interpreter.universe().size(), comprehension.decls().size()));
        this.comprehension(comprehension.decls(), comprehension.formula(), 0, BooleanConstant.TRUE, 0, booleanMatrix);
        return this.cache(comprehension, booleanMatrix);
    }

    @Override
    public BooleanMatrix visit(IfExpression ifExpression) {
        BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(ifExpression);
        if (booleanMatrix != null) {
            return booleanMatrix;
        }
        BooleanValue booleanValue = ifExpression.condition().accept(this);
        BooleanMatrix booleanMatrix2 = ifExpression.thenExpr().accept(this);
        BooleanMatrix booleanMatrix3 = ifExpression.elseExpr().accept(this);
        booleanMatrix = booleanMatrix2.choice(booleanValue, booleanMatrix3);
        return this.cache(ifExpression, booleanMatrix);
    }

    @Override
    public final BooleanMatrix visit(ProjectExpression projectExpression) {
        BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(projectExpression);
        if (booleanMatrix != null) {
            return booleanMatrix;
        }
        Int[] intArray = new Int[projectExpression.arity()];
        int n = projectExpression.arity();
        for (int i = 0; i < n; ++i) {
            intArray[i] = projectExpression.column(i).accept(this);
        }
        return this.cache(projectExpression, projectExpression.expression().accept(this).project(intArray));
    }

    @Override
    public final BooleanValue visit(ConstantFormula constantFormula) {
        return this.cache(constantFormula, BooleanConstant.constant(constantFormula.booleanValue()));
    }

    private void all(Decls decls, Formula formula, int n, BooleanValue booleanValue, BooleanAccumulator booleanAccumulator) {
        if (booleanAccumulator.isShortCircuited()) {
            return;
        }
        BooleanFactory booleanFactory = this.interpreter.factory();
        if (decls.size() == n) {
            booleanAccumulator.add(booleanFactory.or(booleanValue, formula.accept(this)));
            return;
        }
        Decl decl = decls.get(n);
        BooleanMatrix booleanMatrix = this.visit(decl);
        BooleanMatrix booleanMatrix2 = booleanFactory.matrix(booleanMatrix.dimensions());
        this.env = this.env.extend(decl.variable(), booleanMatrix2);
        for (IndexedEntry<BooleanValue> indexedEntry : booleanMatrix) {
            booleanMatrix2.set(indexedEntry.index(), BooleanConstant.TRUE);
            this.all(decls, formula, n + 1, booleanFactory.or(booleanFactory.not(indexedEntry.value()), booleanValue), booleanAccumulator);
            booleanMatrix2.set(indexedEntry.index(), BooleanConstant.FALSE);
        }
        this.env = this.env.parent();
    }

    private void some(Decls decls, Formula formula, int n, BooleanValue booleanValue, BooleanAccumulator booleanAccumulator) {
        if (booleanAccumulator.isShortCircuited()) {
            return;
        }
        BooleanFactory booleanFactory = this.interpreter.factory();
        if (decls.size() == n) {
            booleanAccumulator.add(booleanFactory.and(booleanValue, formula.accept(this)));
            return;
        }
        Decl decl = decls.get(n);
        BooleanMatrix booleanMatrix = this.visit(decl);
        BooleanMatrix booleanMatrix2 = booleanFactory.matrix(booleanMatrix.dimensions());
        this.env = this.env.extend(decl.variable(), booleanMatrix2);
        for (IndexedEntry<BooleanValue> indexedEntry : booleanMatrix) {
            booleanMatrix2.set(indexedEntry.index(), BooleanConstant.TRUE);
            this.some(decls, formula, n + 1, booleanFactory.and(indexedEntry.value(), booleanValue), booleanAccumulator);
            booleanMatrix2.set(indexedEntry.index(), BooleanConstant.FALSE);
        }
        this.env = this.env.parent();
    }

    @Override
    public final BooleanValue visit(QuantifiedFormula quantifiedFormula) {
        BooleanValue booleanValue = (BooleanValue)this.lookup(quantifiedFormula);
        if (booleanValue != null) {
            return booleanValue;
        }
        Quantifier quantifier = quantifiedFormula.quantifier();
        switch (quantifier) {
            case ALL: {
                BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND);
                this.all(quantifiedFormula.decls(), quantifiedFormula.formula(), 0, BooleanConstant.FALSE, booleanAccumulator);
                booleanValue = this.interpreter.factory().accumulate(booleanAccumulator);
                break;
            }
            case SOME: {
                BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.OR);
                this.some(quantifiedFormula.decls(), quantifiedFormula.formula(), 0, BooleanConstant.TRUE, booleanAccumulator);
                booleanValue = this.interpreter.factory().accumulate(booleanAccumulator);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown quantifier: " + (Object)((Object)quantifier));
            }
        }
        return this.cache(quantifiedFormula, booleanValue);
    }

    @Override
    public final BooleanValue visit(NaryFormula naryFormula) {
        Operator.Nary nary;
        BooleanValue booleanValue = (BooleanValue)this.lookup(naryFormula);
        if (booleanValue != null) {
            return booleanValue;
        }
        FormulaOperator formulaOperator = naryFormula.op();
        switch (formulaOperator) {
            case AND: {
                nary = Operator.AND;
                break;
            }
            case OR: {
                nary = Operator.OR;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown nary operator: " + (Object)((Object)formulaOperator));
            }
        }
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(nary);
        BooleanConstant booleanConstant = nary.shortCircuit();
        for (Formula formula : naryFormula) {
            if (booleanAccumulator.add(formula.accept(this)) == booleanConstant) break;
        }
        return this.cache(naryFormula, this.interpreter.factory().accumulate(booleanAccumulator));
    }

    @Override
    public final BooleanValue visit(BinaryFormula binaryFormula) {
        BooleanValue booleanValue = (BooleanValue)this.lookup(binaryFormula);
        if (booleanValue != null) {
            return booleanValue;
        }
        BooleanValue booleanValue2 = binaryFormula.left().accept(this);
        BooleanValue booleanValue3 = binaryFormula.right().accept(this);
        FormulaOperator formulaOperator = binaryFormula.op();
        BooleanFactory booleanFactory = this.interpreter.factory();
        switch (formulaOperator) {
            case AND: {
                booleanValue = booleanFactory.and(booleanValue2, booleanValue3);
                break;
            }
            case OR: {
                booleanValue = booleanFactory.or(booleanValue2, booleanValue3);
                break;
            }
            case IMPLIES: {
                booleanValue = booleanFactory.implies(booleanValue2, booleanValue3);
                break;
            }
            case IFF: {
                booleanValue = booleanFactory.iff(booleanValue2, booleanValue3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)formulaOperator));
            }
        }
        return this.cache(binaryFormula, booleanValue);
    }

    @Override
    public final BooleanValue visit(NotFormula notFormula) {
        BooleanValue booleanValue = (BooleanValue)this.lookup(notFormula);
        return booleanValue == null ? this.cache(notFormula, this.interpreter.factory().not(notFormula.formula().accept(this))) : booleanValue;
    }

    @Override
    public final BooleanValue visit(ComparisonFormula comparisonFormula) {
        BooleanValue booleanValue = (BooleanValue)this.lookup(comparisonFormula);
        if (booleanValue != null) {
            return booleanValue;
        }
        BooleanMatrix booleanMatrix = comparisonFormula.left().accept(this);
        BooleanMatrix booleanMatrix2 = comparisonFormula.right().accept(this);
        ExprCompOperator exprCompOperator = comparisonFormula.op();
        switch (exprCompOperator) {
            case SUBSET: {
                booleanValue = booleanMatrix.subset(booleanMatrix2);
                break;
            }
            case EQUALS: {
                booleanValue = booleanMatrix.eq(booleanMatrix2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)comparisonFormula.op()));
            }
        }
        return this.cache(comparisonFormula, booleanValue);
    }

    @Override
    public final BooleanValue visit(MultiplicityFormula multiplicityFormula) {
        BooleanValue booleanValue = (BooleanValue)this.lookup(multiplicityFormula);
        if (booleanValue != null) {
            return booleanValue;
        }
        BooleanMatrix booleanMatrix = multiplicityFormula.expression().accept(this);
        Multiplicity multiplicity = multiplicityFormula.multiplicity();
        switch (multiplicity) {
            case NO: {
                booleanValue = booleanMatrix.none();
                break;
            }
            case SOME: {
                booleanValue = booleanMatrix.some();
                break;
            }
            case ONE: {
                booleanValue = booleanMatrix.one();
                break;
            }
            case LONE: {
                booleanValue = booleanMatrix.lone();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown multiplicity: " + (Object)((Object)multiplicity));
            }
        }
        return this.cache(multiplicityFormula, booleanValue);
    }

    @Override
    public final BooleanValue visit(RelationPredicate relationPredicate) {
        BooleanValue booleanValue = (BooleanValue)this.lookup(relationPredicate);
        return booleanValue != null ? booleanValue : this.cache(relationPredicate, relationPredicate.toConstraints().accept(this));
    }

    @Override
    public BooleanMatrix visit(IntToExprCast intToExprCast) {
        BooleanMatrix booleanMatrix = (BooleanMatrix)this.lookup(intToExprCast);
        if (booleanMatrix != null) {
            return booleanMatrix;
        }
        Int intVal = intToExprCast.intExpr().accept(this);
        BooleanFactory booleanFactory = this.interpreter.factory();
        IntSet intSet = this.interpreter.ints();
        booleanMatrix = booleanFactory.matrix(Dimensions.square(this.interpreter.universe().size(), 1));
        switch (intToExprCast.op()) {
            case INTCAST: {
                IntIterator intIterator = intSet.iterator();
                while (intIterator.hasNext()) {
                    int n = intIterator.next();
                    int n2 = this.interpreter.interpret(n);
                    booleanMatrix.set(n2, booleanFactory.or(booleanMatrix.get(n2), intVal.eq(booleanFactory.integer(n))));
                }
                break;
            }
            case BITSETCAST: {
                List<BooleanValue> list = intVal.twosComplementBits();
                int n = list.size() - 1;
                for (int i = 0; i < n; ++i) {
                    int n3 = 1 << i;
                    if (!intSet.contains(n3)) continue;
                    booleanMatrix.set(this.interpreter.interpret(n3), list.get(i));
                }
                if (!intSet.contains(-1 << n)) break;
                booleanMatrix.set(this.interpreter.interpret(-1 << n), list.get(n));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown cast operator: " + (Object)((Object)intToExprCast.op()));
            }
        }
        return this.cache(intToExprCast, booleanMatrix);
    }

    @Override
    public final Int visit(IntConstant intConstant) {
        return this.interpreter.factory().integer(intConstant.value());
    }

    @Override
    public final Int visit(IfIntExpression ifIntExpression) {
        Int intVal = (Int)this.lookup(ifIntExpression);
        if (intVal != null) {
            return intVal;
        }
        BooleanValue booleanValue = ifIntExpression.condition().accept(this);
        Int intVal2 = ifIntExpression.thenExpr().accept(this);
        Int intVal3 = ifIntExpression.elseExpr().accept(this);
        intVal = intVal2.choice(booleanValue, intVal3);
        return this.cache(ifIntExpression, intVal);
    }

    private final Int sum(BooleanMatrix booleanMatrix, IntIterator intIterator, int n, int n2) {
        if (n > n2) {
            return this.interpreter.factory().integer(0);
        }
        if (n == n2) {
            int n3 = intIterator.next();
            return this.interpreter.factory().integer(n3, booleanMatrix.get(this.interpreter.interpret(n3)));
        }
        int n4 = (n + n2) / 2;
        Int intVal = this.sum(booleanMatrix, intIterator, n, n4);
        Int intVal2 = this.sum(booleanMatrix, intIterator, n4 + 1, n2);
        return intVal.plus(intVal2);
    }

    @Override
    public final Int visit(ExprToIntCast exprToIntCast) {
        Int intVal = (Int)this.lookup(exprToIntCast);
        if (intVal != null) {
            return intVal;
        }
        switch (exprToIntCast.op()) {
            case CARDINALITY: {
                intVal = exprToIntCast.expression().accept(this).cardinality();
                break;
            }
            case SUM: {
                IntSet intSet = this.interpreter.ints();
                intVal = this.sum(exprToIntCast.expression().accept(this), intSet.iterator(), 0, intSet.size() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown operator: " + (Object)((Object)exprToIntCast.op()));
            }
        }
        return this.cache(exprToIntCast, intVal);
    }

    @Override
    public final Int visit(BinaryIntExpression binaryIntExpression) {
        Int intVal = (Int)this.lookup(binaryIntExpression);
        if (intVal != null) {
            return intVal;
        }
        Int intVal2 = binaryIntExpression.left().accept(this);
        Int intVal3 = binaryIntExpression.right().accept(this);
        switch (binaryIntExpression.op()) {
            case PLUS: {
                intVal = intVal2.plus(intVal3);
                break;
            }
            case MINUS: {
                intVal = intVal2.minus(intVal3);
                break;
            }
            case MULTIPLY: {
                intVal = intVal2.multiply(intVal3);
                break;
            }
            case DIVIDE: {
                intVal = intVal2.divide(intVal3);
                break;
            }
            case MODULO: {
                intVal = intVal2.modulo(intVal3);
                break;
            }
            case AND: {
                intVal = intVal2.and(intVal3);
                break;
            }
            case OR: {
                intVal = intVal2.or(intVal3);
                break;
            }
            case XOR: {
                intVal = intVal2.xor(intVal3);
                break;
            }
            case SHL: {
                intVal = intVal2.shl(intVal3);
                break;
            }
            case SHR: {
                intVal = intVal2.shr(intVal3);
                break;
            }
            case SHA: {
                intVal = intVal2.sha(intVal3);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)binaryIntExpression.op()));
            }
        }
        return this.cache(binaryIntExpression, intVal);
    }

    @Override
    public final Int visit(NaryIntExpression naryIntExpression) {
        Int intVal = (Int)this.lookup(naryIntExpression);
        if (intVal != null) {
            return intVal;
        }
        Int intVal2 = naryIntExpression.child(0).accept(this);
        Int[] intArray = new Int[naryIntExpression.size() - 1];
        for (int i = 0; i < intArray.length; ++i) {
            intArray[i] = naryIntExpression.child(i + 1).accept(this);
        }
        switch (naryIntExpression.op()) {
            case PLUS: {
                intVal = intVal2.plus(intArray);
                break;
            }
            case MULTIPLY: {
                intVal = intVal2.multiply(intArray);
                break;
            }
            case AND: {
                intVal = intVal2.and(intArray);
                break;
            }
            case OR: {
                intVal = intVal2.or(intArray);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown nary operator: " + (Object)((Object)naryIntExpression.op()));
            }
        }
        return this.cache(naryIntExpression, intVal);
    }

    @Override
    public final Int visit(UnaryIntExpression unaryIntExpression) {
        Int intVal = (Int)this.lookup(unaryIntExpression);
        if (intVal != null) {
            return intVal;
        }
        Int intVal2 = unaryIntExpression.intExpr().accept(this);
        switch (unaryIntExpression.op()) {
            case NEG: {
                intVal = intVal2.negate();
                break;
            }
            case NOT: {
                intVal = intVal2.not();
                break;
            }
            case ABS: {
                intVal = intVal2.abs();
                break;
            }
            case SGN: {
                intVal = intVal2.sgn();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)unaryIntExpression.op()));
            }
        }
        return this.cache(unaryIntExpression, intVal);
    }

    private final void sum(Decls decls, IntExpression intExpression, int n, BooleanValue booleanValue, List<Int> list) {
        BooleanFactory booleanFactory = this.interpreter.factory();
        if (decls.size() == n) {
            list.add(intExpression.accept(this).choice(booleanValue, booleanFactory.integer(0)));
            return;
        }
        Decl decl = decls.get(n);
        BooleanMatrix booleanMatrix = this.visit(decl);
        BooleanMatrix booleanMatrix2 = booleanFactory.matrix(booleanMatrix.dimensions());
        this.env = this.env.extend(decl.variable(), booleanMatrix2);
        for (IndexedEntry<BooleanValue> indexedEntry : booleanMatrix) {
            booleanMatrix2.set(indexedEntry.index(), BooleanConstant.TRUE);
            this.sum(decls, intExpression, n + 1, booleanFactory.and(indexedEntry.value(), booleanValue), list);
            booleanMatrix2.set(indexedEntry.index(), BooleanConstant.FALSE);
        }
        this.env = this.env.parent();
    }

    @Override
    public final Int visit(SumExpression sumExpression) {
        Int intVal = (Int)this.lookup(sumExpression);
        if (intVal != null) {
            return intVal;
        }
        ArrayList<Int> arrayList = new ArrayList<Int>();
        this.sum(sumExpression.decls(), sumExpression.intExpr(), 0, BooleanConstant.TRUE, arrayList);
        for (int i = arrayList.size(); i > 1; i -= i / 2) {
            int n = i - 1;
            for (int j = 0; j < n; j += 2) {
                arrayList.set(j / 2, ((Int)arrayList.get(j)).plus((Int)arrayList.get(j + 1)));
            }
            if (n % 2 != 0) continue;
            arrayList.set(n / 2, (Int)arrayList.get(n));
        }
        return this.cache(sumExpression, arrayList.isEmpty() ? this.interpreter.factory().integer(0) : (Int)arrayList.get(0));
    }

    @Override
    public final BooleanValue visit(IntComparisonFormula intComparisonFormula) {
        BooleanValue booleanValue = (BooleanValue)this.lookup(intComparisonFormula);
        if (booleanValue != null) {
            return booleanValue;
        }
        Int intVal = intComparisonFormula.left().accept(this);
        Int intVal2 = intComparisonFormula.right().accept(this);
        switch (intComparisonFormula.op()) {
            case EQ: {
                booleanValue = intVal.eq(intVal2);
                break;
            }
            case LT: {
                booleanValue = intVal.lt(intVal2);
                break;
            }
            case LTE: {
                booleanValue = intVal.lte(intVal2);
                break;
            }
            case GT: {
                booleanValue = intVal.gt(intVal2);
                break;
            }
            case GTE: {
                booleanValue = intVal.gte(intVal2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown operator: " + (Object)((Object)intComparisonFormula.op()));
            }
        }
        return this.cache(intComparisonFormula, booleanValue);
    }
}

