/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.BinaryFormula;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.ConstantFormula;
import kodkod.ast.Decls;
import kodkod.ast.Formula;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryFormula;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.RelationPredicate;
import kodkod.ast.operator.FormulaOperator;
import kodkod.ast.operator.Quantifier;
import kodkod.ast.visitor.AbstractVoidVisitor;
import kodkod.util.nodes.AnnotatedNode;

final class FormulaFlattener
extends AbstractVoidVisitor {
    private Map<Formula, Node> conjuncts = new LinkedHashMap<Formula, Node>();
    private final Map<Node, Boolean> visited;
    private final Set<Node> shared;
    private boolean negated;
    private final boolean breakupQuantifiers;

    public static AnnotatedNode<Formula> flatten(AnnotatedNode<Formula> annotatedNode, boolean bl) {
        FormulaFlattener formulaFlattener = new FormulaFlattener(annotatedNode.sharedNodes(), bl);
        annotatedNode.node().accept(formulaFlattener);
        ArrayList<Formula> arrayList = new ArrayList<Formula>(formulaFlattener.conjuncts.size());
        arrayList.addAll(formulaFlattener.conjuncts.keySet());
        Iterator<Map.Entry<Formula, Node>> iterator = formulaFlattener.conjuncts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Formula, Node> entry = iterator.next();
            Node node = annotatedNode.sourceOf(entry.getValue());
            if (entry.getKey() == node) {
                iterator.remove();
                continue;
            }
            entry.setValue(node);
        }
        return AnnotatedNode.annotate(Formula.and(arrayList), formulaFlattener.conjuncts);
    }

    private FormulaFlattener(Set<Node> set, boolean bl) {
        this.shared = set;
        this.visited = new IdentityHashMap<Node, Boolean>();
        this.negated = false;
        this.breakupQuantifiers = bl;
    }

    final AnnotatedNode<Formula> apply(AnnotatedNode<Formula> annotatedNode) {
        annotatedNode.node().accept(this);
        ArrayList<Formula> arrayList = new ArrayList<Formula>(this.conjuncts.size());
        arrayList.addAll(this.conjuncts.keySet());
        Iterator<Map.Entry<Formula, Node>> iterator = this.conjuncts.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Formula, Node> entry = iterator.next();
            Node node = annotatedNode.sourceOf(entry.getValue());
            if (entry.getKey() == node) {
                iterator.remove();
                continue;
            }
            entry.setValue(node);
        }
        return AnnotatedNode.annotate(Formula.and(arrayList), this.conjuncts);
    }

    @Override
    protected boolean visited(Node node) {
        if (this.shared.contains(node)) {
            if (this.visited.containsKey(node)) {
                Boolean bl = this.visited.get(node);
                if (bl == null || bl == this.negated) {
                    return true;
                }
                this.visited.put(node, null);
                return false;
            }
            this.visited.put(node, this.negated);
            return false;
        }
        return false;
    }

    @Override
    public final void visit(NotFormula notFormula) {
        if (this.visited(notFormula)) {
            return;
        }
        Map<Formula, Node> map = this.conjuncts;
        this.conjuncts = new LinkedHashMap<Formula, Node>();
        this.negated = !this.negated;
        notFormula.formula().accept(this);
        boolean bl = this.negated = !this.negated;
        if (this.conjuncts.size() > 1) {
            map.putAll(this.conjuncts);
            this.conjuncts = map;
        } else {
            this.conjuncts = map;
            this.conjuncts.put(this.negated ? notFormula.formula() : notFormula, notFormula);
        }
    }

    private final void addConjunct(Formula formula) {
        this.conjuncts.put(this.negated ? formula.not() : formula, formula);
    }

    @Override
    public final void visit(BinaryFormula binaryFormula) {
        if (this.visited(binaryFormula)) {
            return;
        }
        FormulaOperator formulaOperator = binaryFormula.op();
        if (formulaOperator == FormulaOperator.IFF || this.negated && formulaOperator == FormulaOperator.AND || !this.negated && (formulaOperator == FormulaOperator.OR || formulaOperator == FormulaOperator.IMPLIES)) {
            this.addConjunct(binaryFormula);
        } else if (this.negated && formulaOperator == FormulaOperator.IMPLIES) {
            this.negated = !this.negated;
            binaryFormula.left().accept(this);
            this.negated = !this.negated;
            binaryFormula.right().accept(this);
        } else {
            binaryFormula.left().accept(this);
            binaryFormula.right().accept(this);
        }
    }

    @Override
    public final void visit(NaryFormula naryFormula) {
        if (this.visited(naryFormula)) {
            return;
        }
        FormulaOperator formulaOperator = naryFormula.op();
        if (this.negated && formulaOperator == FormulaOperator.AND || !this.negated && formulaOperator == FormulaOperator.OR) {
            this.addConjunct(naryFormula);
        } else {
            for (Formula formula : naryFormula) {
                formula.accept(this);
            }
        }
    }

    @Override
    public final void visit(QuantifiedFormula quantifiedFormula) {
        if (this.visited(quantifiedFormula)) {
            return;
        }
        if (this.breakupQuantifiers) {
            Quantifier quantifier = quantifiedFormula.quantifier();
            if (!this.negated && quantifier == Quantifier.ALL || this.negated && quantifier == Quantifier.SOME) {
                Map<Formula, Node> map = this.conjuncts;
                this.conjuncts = new LinkedHashMap<Formula, Node>();
                quantifiedFormula.formula().accept(this);
                if (this.conjuncts.size() > 1) {
                    Decls decls = quantifiedFormula.decls();
                    for (Map.Entry<Formula, Node> entry : this.conjuncts.entrySet()) {
                        map.put(entry.getKey().forAll(decls), entry.getValue());
                    }
                    this.conjuncts = map;
                    return;
                }
                this.conjuncts = map;
            }
        }
        this.addConjunct(quantifiedFormula);
    }

    final void visitFormula(Formula formula) {
        if (this.visited(formula)) {
            return;
        }
        this.addConjunct(formula);
    }

    @Override
    public final void visit(ComparisonFormula comparisonFormula) {
        this.visitFormula(comparisonFormula);
    }

    @Override
    public final void visit(IntComparisonFormula intComparisonFormula) {
        this.visitFormula(intComparisonFormula);
    }

    @Override
    public final void visit(MultiplicityFormula multiplicityFormula) {
        this.visitFormula(multiplicityFormula);
    }

    @Override
    public final void visit(ConstantFormula constantFormula) {
        this.visitFormula(constantFormula);
    }

    @Override
    public final void visit(RelationPredicate relationPredicate) {
        this.visitFormula(relationPredicate);
    }
}

