/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kodkod.ast.Formula;
import kodkod.ast.Node;
import kodkod.ast.Variable;
import kodkod.engine.bool.BooleanMatrix;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.fol2sat.Environment;
import kodkod.engine.fol2sat.RecordFilter;
import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.fol2sat.TranslationLogger;
import kodkod.engine.fol2sat.TranslationRecord;
import kodkod.instance.Bounds;
import kodkod.instance.TupleSet;
import kodkod.util.collections.FixedMap;
import kodkod.util.nodes.AnnotatedNode;
import kodkod.util.nodes.Nodes;

final class MemoryLogger
extends TranslationLogger {
    private final FixedMap<Formula, BooleanValue> logMap;
    private final AnnotatedNode<Formula> annotated;
    private final Bounds bounds;

    MemoryLogger(AnnotatedNode<Formula> annotatedNode, Bounds bounds) {
        this.annotated = annotatedNode;
        this.bounds = bounds;
        this.logMap = new FixedMap(Nodes.conjuncts(annotatedNode.node()));
    }

    @Override
    void close() {
    }

    @Override
    void log(Formula formula, BooleanValue booleanValue, Environment<BooleanMatrix> environment) {
        BooleanValue booleanValue2;
        if (this.logMap.containsKey(formula) && (booleanValue2 = this.logMap.put(formula, booleanValue)) != null && booleanValue2 != booleanValue) {
            throw new IllegalArgumentException("translation of root corresponding to the formula has already been logged: " + formula);
        }
    }

    @Override
    TranslationLog log() {
        return new MemoryLog(this.annotated, this.logMap, this.bounds);
    }

    private static class MemoryLog
    extends TranslationLog {
        private final Set<Formula> roots;
        private final Bounds bounds;
        private final Node[] original;
        private final int[] transl;

        MemoryLog(AnnotatedNode<Formula> annotatedNode, FixedMap<Formula, BooleanValue> fixedMap, Bounds bounds) {
            this.bounds = bounds;
            this.roots = Nodes.conjuncts(annotatedNode.node());
            assert (this.roots.size() == fixedMap.size());
            this.transl = new int[this.roots.size()];
            this.original = new Node[this.roots.size()];
            Iterator<Formula> iterator = this.roots.iterator();
            for (int i = 0; i < this.transl.length; ++i) {
                Formula formula = iterator.next();
                this.transl[i] = fixedMap.get(formula).label();
                this.original[i] = annotatedNode.sourceOf(formula);
            }
        }

        @Override
        public Bounds bounds() {
            return this.bounds;
        }

        @Override
        public Iterator<TranslationRecord> replay(final RecordFilter recordFilter) {
            return new Iterator<TranslationRecord>(){
                final Iterator<Formula> itr;
                boolean ready;
                int index;
                Formula root;
                final TranslationRecord current;
                {
                    this.itr = MemoryLog.this.roots.iterator();
                    this.ready = false;
                    this.index = -1;
                    this.root = null;
                    this.current = new TranslationRecord(){

                        @Override
                        public Map<Variable, TupleSet> env() {
                            return Collections.emptyMap();
                        }

                        @Override
                        public int literal() {
                            return MemoryLog.this.transl[index];
                        }

                        @Override
                        public Node node() {
                            return MemoryLog.this.original[index];
                        }

                        @Override
                        public Formula translated() {
                            return root;
                        }
                    };
                }

                @Override
                public boolean hasNext() {
                    while (!this.ready && this.itr.hasNext()) {
                        this.root = this.itr.next();
                        ++this.index;
                        if (!recordFilter.accept(MemoryLog.this.original[this.index], this.root, MemoryLog.this.transl[this.index], Collections.EMPTY_MAP)) continue;
                        this.ready = true;
                        break;
                    }
                    return this.ready;
                }

                @Override
                public TranslationRecord next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.ready = false;
                    return this.current;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Set<Formula> roots() {
            return this.roots;
        }
    }
}

