/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.fol2sat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.Relation;
import kodkod.ast.RelationPredicate;
import kodkod.engine.bool.BooleanAccumulator;
import kodkod.engine.bool.BooleanConstant;
import kodkod.engine.bool.BooleanFactory;
import kodkod.engine.bool.BooleanMatrix;
import kodkod.engine.bool.BooleanValue;
import kodkod.engine.bool.Operator;
import kodkod.engine.config.Reporter;
import kodkod.engine.fol2sat.LeafInterpreter;
import kodkod.engine.fol2sat.SymmetryDetector;
import kodkod.instance.Bounds;
import kodkod.instance.Tuple;
import kodkod.instance.TupleFactory;
import kodkod.util.ints.IndexedEntry;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

final class SymmetryBreaker {
    private final Bounds bounds;
    private final Set<IntSet> symmetries;
    private final int usize;

    SymmetryBreaker(Bounds bounds, Reporter reporter) {
        this.bounds = bounds;
        this.usize = bounds.universe().size();
        reporter.detectingSymmetries(bounds);
        this.symmetries = SymmetryDetector.partition(bounds);
        reporter.detectedSymmetries(this.symmetries);
    }

    Map<RelationPredicate, Formula> breakMatrixSymmetries(Map<RelationPredicate.Name, Set<RelationPredicate>> map, boolean bl) {
        Formula formula;
        Set<RelationPredicate> set = map.get((Object)RelationPredicate.Name.TOTAL_ORDERING);
        Set<RelationPredicate> set2 = map.get((Object)RelationPredicate.Name.ACYCLIC);
        IdentityHashMap<RelationPredicate, Formula> identityHashMap = new IdentityHashMap<RelationPredicate, Formula>();
        for (RelationPredicate.TotalOrdering relationPredicate : (RelationPredicate.TotalOrdering[])SymmetryBreaker.sort((RelationPredicate[])set.toArray(new RelationPredicate.TotalOrdering[set.size()]))) {
            formula = this.breakTotalOrder(relationPredicate, bl);
            if (formula == null) continue;
            identityHashMap.put(relationPredicate, formula);
        }
        for (RelationPredicate relationPredicate : (RelationPredicate.Acyclic[])SymmetryBreaker.sort((RelationPredicate[])set2.toArray(new RelationPredicate.Acyclic[set2.size()]))) {
            formula = this.breakAcyclic((RelationPredicate.Acyclic)relationPredicate, bl);
            if (formula == null) continue;
            identityHashMap.put(relationPredicate, formula);
        }
        return identityHashMap;
    }

    final BooleanValue generateSBP(LeafInterpreter leafInterpreter, int n) {
        if (this.symmetries.isEmpty() || n == 0) {
            return BooleanConstant.TRUE;
        }
        List<RelationParts> list = this.relParts();
        BooleanFactory booleanFactory = leafInterpreter.factory();
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND);
        ArrayList<BooleanValue> arrayList = new ArrayList<BooleanValue>(n);
        ArrayList<BooleanValue> arrayList2 = new ArrayList<BooleanValue>(n);
        for (IntSet intSet : this.symmetries) {
            IntIterator intIterator = intSet.iterator();
            int n2 = intIterator.next();
            while (intIterator.hasNext()) {
                int n3 = intIterator.next();
                Iterator<RelationParts> iterator = list.iterator();
                while (iterator.hasNext() && arrayList.size() < n) {
                    RelationParts relationParts = iterator.next();
                    Relation relation = relationParts.relation;
                    if (!relationParts.representatives.contains(intSet.min())) continue;
                    BooleanMatrix booleanMatrix = leafInterpreter.interpret(relation);
                    for (IndexedEntry<BooleanValue> indexedEntry : booleanMatrix) {
                        int n4 = this.permutation(relation.arity(), indexedEntry.index(), n2, n3);
                        BooleanValue booleanValue = booleanMatrix.get(n4);
                        if (n4 == indexedEntry.index() || SymmetryBreaker.atSameIndex(arrayList, booleanValue, arrayList2, indexedEntry.value())) continue;
                        arrayList.add(indexedEntry.value());
                        arrayList2.add(booleanValue);
                    }
                }
                booleanAccumulator.add(SymmetryBreaker.leq(booleanFactory, arrayList, arrayList2));
                arrayList.clear();
                arrayList2.clear();
                n2 = n3;
            }
        }
        return booleanFactory.accumulate(booleanAccumulator);
    }

    private List<RelationParts> relParts() {
        ArrayList<RelationParts> arrayList = new ArrayList<RelationParts>(this.bounds.relations().size());
        for (Relation relation : this.bounds.relations()) {
            IntSet intSet = this.bounds.upperBound(relation).indexView();
            if (intSet.size() == this.bounds.lowerBound(relation).size()) continue;
            IntSet intSet2 = Ints.bestSet(this.usize);
            IntIterator intIterator = intSet.iterator();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                int n2 = relation.arity();
                while (n2 > 0) {
                    for (IntSet intSet3 : this.symmetries) {
                        if (!intSet3.contains(n % this.usize)) continue;
                        intSet2.add(intSet3.min());
                        break;
                    }
                    --n2;
                    n /= this.usize;
                }
            }
            arrayList.add(new RelationParts(relation, intSet2));
        }
        Comparator<RelationParts> comparator = new Comparator<RelationParts>(){

            @Override
            public int compare(RelationParts relationParts, RelationParts relationParts2) {
                int n = relationParts.relation.arity() - relationParts2.relation.arity();
                return n != 0 ? n : String.valueOf(relationParts.relation.name()).compareTo(String.valueOf(relationParts2.relation.name()));
            }
        };
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    private static final BooleanValue leq(BooleanFactory booleanFactory, List<BooleanValue> list, List<BooleanValue> list2) {
        BooleanAccumulator booleanAccumulator = BooleanAccumulator.treeGate(Operator.AND);
        BooleanValue booleanValue = BooleanConstant.TRUE;
        for (int i = 0; i < list.size(); ++i) {
            booleanAccumulator.add(booleanFactory.implies(booleanValue, booleanFactory.implies(list.get(i), list2.get(i))));
            booleanValue = booleanFactory.and(booleanValue, booleanFactory.iff(list.get(i), list2.get(i)));
        }
        return booleanFactory.accumulate(booleanAccumulator);
    }

    private final int permutation(int n, int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 1;
        while (n > 0) {
            int n7 = n2 % this.usize;
            n5 = n7 == n3 ? (n5 += n4 * n6) : (n7 == n4 ? (n5 += n3 * n6) : (n5 += n7 * n6));
            --n;
            n2 /= this.usize;
            n6 *= this.usize;
        }
        return n5;
    }

    private static boolean atSameIndex(List<BooleanValue> list, BooleanValue booleanValue, List<BooleanValue> list2, BooleanValue booleanValue2) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).equals(booleanValue) || !list2.get(i).equals(booleanValue2)) continue;
            return true;
        }
        return false;
    }

    private static final <P extends RelationPredicate> P[] sort(P[] PArray) {
        Comparator<RelationPredicate> comparator = new Comparator<RelationPredicate>(){

            @Override
            public int compare(RelationPredicate relationPredicate, RelationPredicate relationPredicate2) {
                return String.valueOf(relationPredicate.relation().name()).compareTo(String.valueOf(relationPredicate2.relation().name()));
            }
        };
        Arrays.sort(PArray, comparator);
        return PArray;
    }

    private final Formula breakAcyclic(RelationPredicate.Acyclic acyclic, boolean bl) {
        IntSet[] intSetArray = this.symmetricColumnPartitions(acyclic.relation());
        if (intSetArray != null) {
            Relation relation = acyclic.relation();
            IntSet intSet = this.bounds.upperBound(relation).indexView();
            IntSet intSet2 = Ints.bestSet(this.usize * this.usize);
            Object object = intSet.iterator();
            while (object.hasNext()) {
                int n;
                int n2 = object.next();
                if (n2 == (n = n2 / this.usize + n2 % this.usize * this.usize)) continue;
                if (!intSet.contains(n)) {
                    return null;
                }
                if (intSet2.contains(n)) continue;
                intSet2.add(n2);
            }
            this.removePartition(intSetArray[0].min());
            if (bl) {
                this.bounds.bound(relation, this.bounds.universe().factory().setOf(2, intSet2));
                return Formula.TRUE;
            }
            object = Relation.binary("SYM_BREAK_CONST_" + acyclic.relation().name());
            this.bounds.boundExactly((Relation)object, this.bounds.universe().factory().setOf(2, intSet2));
            return relation.in((Expression)object);
        }
        return null;
    }

    private final Formula breakTotalOrder(RelationPredicate.TotalOrdering totalOrdering, boolean bl) {
        Relation relation = totalOrdering.first();
        Relation relation2 = totalOrdering.last();
        Relation relation3 = totalOrdering.ordered();
        Relation relation4 = totalOrdering.relation();
        IntSet intSet = this.bounds.upperBound(relation3).indexView();
        if (this.symmetricColumnPartitions(relation3) != null && this.bounds.upperBound(relation).indexView().contains(intSet.min()) && this.bounds.upperBound(relation2).indexView().contains(intSet.max())) {
            IntSet intSet2 = Ints.bestSet(this.usize * this.usize);
            int n = intSet.min();
            Object object = intSet.iterator(n + 1, this.usize);
            while (object.hasNext()) {
                int n2 = object.next();
                intSet2.add(n * this.usize + n2);
                n = n2;
            }
            if (intSet2.containsAll(this.bounds.lowerBound(relation4).indexView()) && this.bounds.upperBound(relation4).indexView().containsAll(intSet2)) {
                this.removePartition(intSet.min());
                object = this.bounds.universe().factory();
                if (bl) {
                    this.bounds.boundExactly(relation, ((TupleFactory)object).setOf(((TupleFactory)object).tuple(1, intSet.min()), new Tuple[0]));
                    this.bounds.boundExactly(relation2, ((TupleFactory)object).setOf(((TupleFactory)object).tuple(1, intSet.max()), new Tuple[0]));
                    this.bounds.boundExactly(relation3, this.bounds.upperBound(totalOrdering.ordered()));
                    this.bounds.boundExactly(relation4, ((TupleFactory)object).setOf(2, intSet2));
                    return Formula.TRUE;
                }
                Relation relation5 = Relation.unary("SYM_BREAK_CONST_" + relation.name());
                Relation relation6 = Relation.unary("SYM_BREAK_CONST_" + relation2.name());
                Relation relation7 = Relation.unary("SYM_BREAK_CONST_" + relation3.name());
                Relation relation8 = Relation.binary("SYM_BREAK_CONST_" + relation4.name());
                this.bounds.boundExactly(relation5, ((TupleFactory)object).setOf(((TupleFactory)object).tuple(1, intSet.min()), new Tuple[0]));
                this.bounds.boundExactly(relation6, ((TupleFactory)object).setOf(((TupleFactory)object).tuple(1, intSet.max()), new Tuple[0]));
                this.bounds.boundExactly(relation7, this.bounds.upperBound(totalOrdering.ordered()));
                this.bounds.boundExactly(relation8, ((TupleFactory)object).setOf(2, intSet2));
                return Formula.and(relation.eq(relation5), relation2.eq(relation6), relation3.eq(relation7), relation4.eq(relation8));
            }
        }
        return null;
    }

    private final void removePartition(int n) {
        Iterator<IntSet> iterator = this.symmetries.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().contains(n)) continue;
            iterator.remove();
            break;
        }
    }

    private final IntSet[] symmetricColumnPartitions(Relation relation) {
        IntSet intSet = this.bounds.upperBound(relation).indexView();
        if (intSet.isEmpty()) {
            return null;
        }
        IntSet[] intSetArray = new IntSet[relation.arity()];
        int n = relation.arity() - 1;
        int n2 = intSet.min();
        while (n >= 0) {
            for (IntSet intSet2 : this.symmetries) {
                if (!intSet2.contains(n2 % this.usize)) continue;
                intSetArray[n] = intSet2;
                break;
            }
            if (intSetArray[n] == null) {
                return null;
            }
            --n;
            n2 /= this.usize;
        }
        IntIterator intIterator = intSet.iterator();
        while (intIterator.hasNext()) {
            n2 = relation.arity() - 1;
            int n3 = intIterator.next();
            while (n2 >= 0) {
                if (!intSetArray[n2].contains(n3 % this.usize)) {
                    return null;
                }
                --n2;
                n3 /= this.usize;
            }
        }
        return intSetArray;
    }

    private static final class RelationParts {
        final Relation relation;
        final IntSet representatives;

        RelationParts(Relation relation, IntSet intSet) {
            this.relation = relation;
            this.representatives = intSet;
        }
    }
}

