/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.satlab;

import java.util.Iterator;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.Ints;

public abstract class Clause {
    protected Clause() {
    }

    public abstract int size();

    public abstract IntIterator literals();

    public abstract int maxVariable();

    public abstract int[] toArray(int[] var1);

    public int[] toArray() {
        return this.toArray(new int[this.size()]);
    }

    public abstract int numberOfAntecedents();

    public abstract Iterator<Clause> antecedents();

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Clause) {
            int n;
            Object object2;
            Clause clause = (Clause)object;
            if (this.size() == clause.size()) {
                IntIterator intIterator = this.literals();
                object2 = this.literals();
                while (intIterator.hasNext()) {
                    if (intIterator.next() == object2.next()) continue;
                    return false;
                }
            }
            if ((n = this.numberOfAntecedents()) > 0 && n == clause.numberOfAntecedents()) {
                object2 = this.antecedents();
                Iterator<Clause> iterator = clause.antecedents();
                while (object2.hasNext()) {
                    if (((Clause)object2.next()).equals(iterator.next())) continue;
                    return false;
                }
            }
            return n == 0;
        }
        return false;
    }

    public int hashCode() {
        int n = this.size() + this.numberOfAntecedents();
        Object object = this.literals();
        while (object.hasNext()) {
            n = Ints.superFastHashIncremental(object.next(), n);
        }
        object = this.antecedents();
        while (object.hasNext()) {
            n = Ints.superFastHash(((Clause)object.next()).hashCode(), n);
        }
        return Ints.superFastHashAvalanche(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.numberOfAntecedents() == 0) {
            stringBuilder.append("AXIOM");
        } else {
            stringBuilder.append("RESOLVENT");
        }
        stringBuilder.append(". Literals: {");
        IntIterator intIterator = this.literals();
        while (intIterator.hasNext()) {
            stringBuilder.append(" ");
            stringBuilder.append(intIterator.next());
        }
        stringBuilder.append(" }");
        return stringBuilder.toString();
    }
}

