/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.satlab;

import kodkod.engine.satlab.Clause;
import kodkod.engine.satlab.LazyTrace;
import kodkod.engine.satlab.NativeSolver;
import kodkod.engine.satlab.ReductionStrategy;
import kodkod.engine.satlab.ResolutionTrace;
import kodkod.engine.satlab.SATProver;
import kodkod.util.ints.IntBitSet;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;

final class MiniSatProver
extends NativeSolver
implements SATProver {
    private LazyTrace proof = null;

    MiniSatProver() {
        super(MiniSatProver.make());
    }

    private int[][] format(int[][] nArray) {
        int[] nArray2;
        int n;
        int n2 = nArray.length;
        IntBitSet intBitSet = new IntBitSet(n2);
        int n3 = this.numberOfVariables() + 1;
        for (n = 0; n < n2; ++n) {
            nArray2 = nArray[n];
            if (nArray2 == null || nArray2[0] < n3) continue;
            nArray2[0] = nArray2[0] - n3;
            intBitSet.add(n);
        }
        n = n2 - intBitSet.size();
        if (intBitSet.min() < n) {
            int[] nArray3;
            nArray2 = new int[n2];
            int n4 = 0;
            int n5 = n;
            for (int i = 0; i < n2; ++i) {
                if (intBitSet.contains(i)) {
                    nArray2[i] = n5++;
                    nArray3 = nArray[i];
                    int n6 = nArray3.length;
                    for (int j = 0; j < n6; ++j) {
                        nArray3[j] = nArray2[nArray3[j]];
                    }
                    continue;
                }
                nArray2[i] = n4++;
            }
            IntIterator intIterator = intBitSet.iterator(n2, 0);
            while (intIterator.hasNext()) {
                n4 = intIterator.next();
                if (n4 == (n5 = nArray2[n4])) continue;
                nArray3 = nArray[n4];
                System.arraycopy(nArray, n4 + 1, nArray, n4, n5 - n4);
                nArray[n5] = nArray3;
            }
        }
        assert (n == this.numberOfClauses());
        return nArray;
    }

    @Override
    public ResolutionTrace proof() {
        if (!Boolean.FALSE.equals(this.status())) {
            throw new IllegalStateException();
        }
        if (this.proof == null) {
            int[][] nArray = this.trace(this.peer(), true);
            this.free();
            this.proof = new LazyTrace(this.format(nArray), this.numberOfClauses());
        }
        return this.proof;
    }

    @Override
    public void reduce(ReductionStrategy reductionStrategy) {
        this.proof();
        IntSet intSet = reductionStrategy.next(this.proof);
        while (!intSet.isEmpty()) {
            long l = MiniSatProver.make();
            this.addVariables(l, this.numberOfVariables());
            Object object = this.proof.iterator(intSet);
            while (object.hasNext()) {
                Clause clause = object.next();
                if (!this.addClause(l, clause.toArray())) {
                    throw new AssertionError((Object)("could not add non-redundant clause: " + clause));
                }
            }
            if (!this.solve(l)) {
                this.adjustClauseCount(intSet.size());
                object = this.trace(l, false);
                this.free(l);
                this.proof = new LazyTrace(this.proof, intSet, this.format((int[][])object));
            } else {
                this.free(l);
            }
            intSet = reductionStrategy.next(this.proof);
        }
    }

    public String toString() {
        return "MiniSatProver";
    }

    private static native long make();

    @Override
    native void free(long var1);

    @Override
    native void addVariables(long var1, int var3);

    @Override
    native boolean addClause(long var1, int[] var3);

    @Override
    native boolean solve(long var1);

    @Override
    native boolean valueOf(long var1, int var3);

    native int[][] trace(long var1, boolean var3);

    static {
        MiniSatProver.loadLibrary(MiniSatProver.class);
    }
}

