/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.satlab;

import java.io.File;
import kodkod.engine.satlab.SATSolver;

abstract class NativeSolver
implements SATSolver {
    private long peer;
    private Boolean sat;
    private int clauses;
    private int vars;

    NativeSolver(long l) {
        this.peer = l;
        this.vars = 0;
        this.clauses = 0;
        this.sat = null;
    }

    static void loadLibrary(Class<? extends NativeSolver> clazz) {
        String string = clazz.getSimpleName().toLowerCase();
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            String string2 = System.getProperty("kodkod." + string);
            if (string2 != null) {
                for (String string3 : string2.split(File.pathSeparator)) {
                    try {
                        System.loadLibrary(string + string3);
                        return;
                    }
                    catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                    }
                }
            }
            throw new UnsatisfiedLinkError("Could not load the library " + System.mapLibraryName(string) + " or any of its variants.");
        }
    }

    @Override
    public final int numberOfVariables() {
        return this.vars;
    }

    @Override
    public final int numberOfClauses() {
        return this.clauses;
    }

    void adjustClauseCount(int n) {
        assert (n >= 0);
        this.clauses = n;
    }

    @Override
    public void addVariables(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("vars < 0: " + n);
        }
        if (n > 0) {
            this.vars += n;
            this.addVariables(this.peer, n);
        }
    }

    @Override
    public final boolean addClause(int[] nArray) {
        if (nArray.length > 0 && this.addClause(this.peer, nArray)) {
            ++this.clauses;
            return true;
        }
        return false;
    }

    final long peer() {
        return this.peer;
    }

    final Boolean status() {
        return this.sat;
    }

    @Override
    public final boolean solve() {
        this.sat = this.solve(this.peer);
        return this.sat;
    }

    final void validateVariable(int n) {
        if (n < 1 || n > this.vars) {
            throw new IllegalArgumentException(n + " !in [1.." + this.vars + "]");
        }
    }

    @Override
    public final boolean valueOf(int n) {
        if (!Boolean.TRUE.equals(this.sat)) {
            throw new IllegalStateException();
        }
        this.validateVariable(n);
        return this.valueOf(this.peer, n);
    }

    @Override
    public final synchronized void free() {
        if (this.peer != 0L) {
            this.free(this.peer);
            this.peer = 0L;
        }
    }

    protected final void finalize() throws Throwable {
        super.finalize();
        this.free();
    }

    abstract void free(long var1);

    abstract void addVariables(long var1, int var3);

    abstract boolean addClause(long var1, int[] var3);

    abstract boolean solve(long var1);

    abstract boolean valueOf(long var1, int var3);
}

