/*
 * Decompiled with CFR 0.152.
 */
package kodkod.engine.ucore;

import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.Formula;
import kodkod.ast.Node;
import kodkod.ast.Variable;
import kodkod.engine.fol2sat.RecordFilter;
import kodkod.engine.fol2sat.TranslationLog;
import kodkod.engine.fol2sat.TranslationRecord;
import kodkod.engine.satlab.Clause;
import kodkod.engine.satlab.ResolutionTrace;
import kodkod.instance.TupleSet;
import kodkod.util.ints.IntBitSet;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.IntTreeSet;
import kodkod.util.ints.Ints;
import kodkod.util.ints.SparseSequence;
import kodkod.util.ints.TreeSequence;

public final class StrategyUtils {
    private StrategyUtils() {
    }

    public static IntSet rootVars(TranslationLog translationLog) {
        Object object;
        IntTreeSet intTreeSet = new IntTreeSet();
        final Set<Formula> set = translationLog.roots();
        LinkedHashMap<Formula, int[]> linkedHashMap = new LinkedHashMap<Formula, int[]>(set.size());
        RecordFilter recordFilter = new RecordFilter(){

            @Override
            public boolean accept(Node node, Formula formula, int n, Map<Variable, TupleSet> map) {
                return set.contains(formula) && map.isEmpty();
            }
        };
        Iterator<TranslationRecord> iterator = translationLog.replay(recordFilter);
        while (iterator.hasNext()) {
            object = iterator.next();
            int[] nArray = (int[])linkedHashMap.get(((TranslationRecord)object).translated());
            if (nArray == null) {
                nArray = new int[1];
                linkedHashMap.put(((TranslationRecord)object).translated(), nArray);
            }
            nArray[0] = StrictMath.abs(((TranslationRecord)object).literal());
        }
        iterator = linkedHashMap.values().iterator();
        while (iterator.hasNext()) {
            object = (int[])iterator.next();
            Object object2 = object[0];
            if (object2 == Integer.MAX_VALUE) continue;
            intTreeSet.add((int)object[0]);
        }
        return intTreeSet;
    }

    static SparseSequence<Formula> roots(TranslationLog translationLog) {
        TreeSequence<Formula> treeSequence = new TreeSequence<Formula>();
        final Set<Formula> set = translationLog.roots();
        IdentityHashMap<Formula, int[]> identityHashMap = new IdentityHashMap<Formula, int[]>(set.size());
        RecordFilter recordFilter = new RecordFilter(){

            @Override
            public boolean accept(Node node, Formula formula, int n, Map<Variable, TupleSet> map) {
                return set.contains(formula) && map.isEmpty();
            }
        };
        Iterator<Object> iterator = translationLog.replay(recordFilter);
        while (iterator.hasNext()) {
            TranslationRecord object = iterator.next();
            int[] n = (int[])identityHashMap.get(object.translated());
            if (n == null) {
                n = new int[1];
                identityHashMap.put(object.translated(), n);
            }
            n[0] = StrictMath.abs(object.literal());
        }
        for (Map.Entry entry : identityHashMap.entrySet()) {
            int n = ((int[])entry.getValue())[0];
            if (n == Integer.MAX_VALUE) continue;
            treeSequence.put(n, (Formula)entry.getKey());
        }
        return treeSequence;
    }

    public static IntSet coreVars(ResolutionTrace resolutionTrace) {
        IntTreeSet intTreeSet = new IntTreeSet();
        IntTreeSet intTreeSet2 = new IntTreeSet();
        Object object = resolutionTrace.iterator(resolutionTrace.core());
        while (object.hasNext()) {
            Clause clause = object.next();
            IntIterator intIterator = clause.literals();
            while (intIterator.hasNext()) {
                int n = intIterator.next();
                if (n > 0) {
                    intTreeSet.add(n);
                    continue;
                }
                intTreeSet2.add(-n);
            }
        }
        intTreeSet.retainAll(intTreeSet2);
        assert (!intTreeSet.isEmpty());
        object = new IntBitSet(intTreeSet.max() + 1);
        object.addAll(intTreeSet);
        return object;
    }

    public static IntSet coreUnits(ResolutionTrace resolutionTrace) {
        IntTreeSet intTreeSet = new IntTreeSet();
        Iterator<Clause> iterator = resolutionTrace.reverseIterator(resolutionTrace.core());
        while (iterator.hasNext()) {
            Clause clause = iterator.next();
            if (clause.size() != 1) continue;
            intTreeSet.add(clause.maxVariable());
        }
        if (intTreeSet.isEmpty()) {
            return Ints.EMPTY_SET;
        }
        return Ints.asSet(intTreeSet.toArray());
    }

    static IntSet coreTailUnits(ResolutionTrace resolutionTrace) {
        Clause clause;
        IntTreeSet intTreeSet = new IntTreeSet();
        Iterator<Clause> iterator = resolutionTrace.reverseIterator(resolutionTrace.core());
        while (iterator.hasNext() && (clause = iterator.next()).size() == 1) {
            intTreeSet.add(clause.maxVariable());
        }
        return intTreeSet;
    }

    static IntSet clausesFor(ResolutionTrace resolutionTrace, IntSet intSet) {
        IntSet intSet2 = resolutionTrace.axioms();
        IntBitSet intBitSet = new IntBitSet(intSet.max() + 1);
        intBitSet.addAll(intSet);
        IntBitSet intBitSet2 = new IntBitSet(intSet2.size());
        Iterator<Clause> iterator = resolutionTrace.reverseIterator(intSet2);
        for (int i = intSet2.max(); i >= 0; --i) {
            Clause clause = iterator.next();
            int n = clause.maxVariable();
            if (!intBitSet.contains(n)) continue;
            IntIterator intIterator = clause.literals();
            while (intIterator.hasNext()) {
                intBitSet.add(StrictMath.abs(intIterator.next()));
            }
            intBitSet2.add(i);
        }
        return intBitSet2;
    }
}

