/*
 * Decompiled with CFR 0.152.
 */
package kodkod.instance;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.Relation;
import kodkod.instance.TupleFactory;
import kodkod.instance.TupleSet;
import kodkod.instance.Universe;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;
import kodkod.util.ints.SparseSequence;
import kodkod.util.ints.TreeSequence;

public final class Bounds
implements Cloneable {
    private final TupleFactory factory;
    private final Map<Relation, TupleSet> lowers;
    private final Map<Relation, TupleSet> uppers;
    private final SparseSequence<TupleSet> intbounds;

    private Bounds(TupleFactory tupleFactory, Map<Relation, TupleSet> map, Map<Relation, TupleSet> map2, SparseSequence<TupleSet> sparseSequence) {
        this.factory = tupleFactory;
        this.lowers = map;
        this.uppers = map2;
        this.intbounds = sparseSequence;
    }

    public Bounds(Universe universe) {
        this.factory = universe.factory();
        this.lowers = new LinkedHashMap<Relation, TupleSet>();
        this.uppers = new LinkedHashMap<Relation, TupleSet>();
        this.intbounds = new TreeSequence<TupleSet>();
    }

    public Universe universe() {
        return this.factory.universe();
    }

    public Set<Relation> relations() {
        return this.lowers.keySet();
    }

    public IntSet ints() {
        return this.intbounds.indices();
    }

    public TupleSet lowerBound(Relation relation) {
        return this.lowers.get(relation);
    }

    public Map<Relation, TupleSet> lowerBounds() {
        return Collections.unmodifiableMap(this.lowers);
    }

    public TupleSet upperBound(Relation relation) {
        return this.uppers.get(relation);
    }

    public Map<Relation, TupleSet> upperBounds() {
        return Collections.unmodifiableMap(this.uppers);
    }

    public TupleSet exactBound(int n) {
        return this.intbounds.get(n);
    }

    public SparseSequence<TupleSet> intBounds() {
        return Ints.unmodifiableSequence(this.intbounds);
    }

    private void checkBound(int n, TupleSet tupleSet) {
        if (n != tupleSet.arity()) {
            throw new IllegalArgumentException("bound.arity != r.arity");
        }
        if (!tupleSet.universe().equals(this.factory.universe())) {
            throw new IllegalArgumentException("bound.universe != this.universe");
        }
    }

    public void boundExactly(Relation relation, TupleSet tupleSet) {
        this.checkBound(relation.arity(), tupleSet);
        TupleSet tupleSet2 = tupleSet.clone().unmodifiableView();
        this.lowers.put(relation, tupleSet2);
        this.uppers.put(relation, tupleSet2);
    }

    public void bound(Relation relation, TupleSet tupleSet, TupleSet tupleSet2) {
        if (!tupleSet2.containsAll(tupleSet)) {
            throw new IllegalArgumentException("lower.tuples !in upper.tuples");
        }
        if (tupleSet2.size() == tupleSet.size()) {
            this.boundExactly(relation, tupleSet);
        } else {
            this.checkBound(relation.arity(), tupleSet);
            this.checkBound(relation.arity(), tupleSet2);
            this.lowers.put(relation, tupleSet.clone().unmodifiableView());
            this.uppers.put(relation, tupleSet2.clone().unmodifiableView());
        }
    }

    public void bound(Relation relation, TupleSet tupleSet) {
        this.checkBound(relation.arity(), tupleSet);
        this.lowers.put(relation, this.factory.noneOf(relation.arity()).unmodifiableView());
        this.uppers.put(relation, tupleSet.clone().unmodifiableView());
    }

    public void boundExactly(int n, TupleSet tupleSet) {
        this.checkBound(1, tupleSet);
        if (tupleSet.size() != 1) {
            throw new IllegalArgumentException("ibound.size != 1: " + tupleSet);
        }
        this.intbounds.put(n, tupleSet.clone().unmodifiableView());
    }

    public Bounds unmodifiableView() {
        return new Bounds(this.factory, Collections.unmodifiableMap(this.lowers), Collections.unmodifiableMap(this.uppers), Ints.unmodifiableSequence(this.intbounds));
    }

    public Bounds clone() {
        try {
            return new Bounds(this.factory, new LinkedHashMap<Relation, TupleSet>(this.lowers), new LinkedHashMap<Relation, TupleSet>(this.uppers), this.intbounds.clone());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("relation bounds:");
        for (Map.Entry<Relation, TupleSet> entry : this.lowers.entrySet()) {
            stringBuilder.append("\n ");
            stringBuilder.append(entry.getKey());
            stringBuilder.append(": [");
            stringBuilder.append(entry.getValue());
            TupleSet tupleSet = this.uppers.get(entry.getKey());
            if (!tupleSet.equals(entry.getValue())) {
                stringBuilder.append(", ");
                stringBuilder.append(tupleSet);
            }
            stringBuilder.append("]");
        }
        stringBuilder.append("\nint bounds: ");
        stringBuilder.append("\n ");
        stringBuilder.append(this.intbounds);
        return stringBuilder.toString();
    }
}

