/*
 * Decompiled with CFR 0.152.
 */
package kodkod.instance;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import kodkod.instance.Tuple;
import kodkod.instance.TupleFactory;
import kodkod.instance.Universe;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

public final class TupleSet
extends AbstractSet<Tuple>
implements Cloneable {
    private final Universe universe;
    private final int arity;
    private final IntSet tuples;
    private IntSet indexView = null;

    TupleSet(Universe universe, int n) {
        if (n < 1) {
            throw new IllegalArgumentException("arity < 1");
        }
        universe.factory().checkCapacity(n);
        this.universe = universe;
        this.arity = n;
        this.tuples = Ints.bestSet(this.capacity());
    }

    TupleSet(Universe universe, int n, int n2, int n3) {
        this(universe, n);
        this.checkRange(n3, 0, this.capacity() - 1);
        this.checkRange(n2, 0, n3);
        for (int i = n2; i <= n3; ++i) {
            this.tuples.add(i);
        }
    }

    TupleSet(Universe universe, int n, IntSet intSet) {
        if (n < 1) {
            throw new IllegalArgumentException("arity < 1");
        }
        universe.factory().checkCapacity(n);
        this.universe = universe;
        this.arity = n;
        if (!(intSet.isEmpty() || intSet.min() >= 0 && intSet.max() < this.capacity())) {
            throw new IllegalArgumentException(intSet.min() + "<0 || " + intSet.max() + ">=" + universe.size() + "^" + n);
        }
        this.tuples = intSet;
    }

    private TupleSet(TupleSet tupleSet) {
        this.universe = tupleSet.universe;
        this.arity = tupleSet.arity;
        try {
            this.tuples = tupleSet.tuples.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        this.indexView = null;
    }

    private final void checkRange(int n, int n2, int n3) {
        if (n < n2 || n > n3) {
            throw new IndexOutOfBoundsException(n + " !in " + "[" + n2 + ".." + n3 + "]");
        }
    }

    public final int capacity() {
        return (int)StrictMath.pow(this.universe.size(), this.arity);
    }

    public Universe universe() {
        return this.universe;
    }

    public int arity() {
        return this.arity;
    }

    public IntSet indexView() {
        if (this.indexView == null) {
            this.indexView = Ints.unmodifiableIntSet(this.tuples);
        }
        return this.indexView;
    }

    public TupleSet unmodifiableView() {
        return new TupleSet(this.universe, this.arity, this.indexView());
    }

    public TupleSet product(TupleSet tupleSet) {
        if (!tupleSet.universe().equals(this.universe)) {
            throw new IllegalArgumentException("s.universe != this.universe");
        }
        TupleSet tupleSet2 = new TupleSet(this.universe, this.arity + tupleSet.arity());
        if (!tupleSet.isEmpty()) {
            int n = (int)StrictMath.pow(this.universe.size(), tupleSet.arity);
            IntIterator intIterator = this.tuples.iterator();
            while (intIterator.hasNext()) {
                int n2 = n * intIterator.next();
                IntIterator intIterator2 = tupleSet.tuples.iterator();
                while (intIterator2.hasNext()) {
                    tupleSet2.tuples.add(n2 + intIterator2.next());
                }
            }
        }
        return tupleSet2;
    }

    public TupleSet project(int n) {
        if (n < 0 || n >= this.arity) {
            throw new IllegalArgumentException("dimension < 0 || dimension >= this.arity");
        }
        IntSet intSet = Ints.bestSet(this.universe.size());
        TupleFactory tupleFactory = this.universe.factory();
        IntIterator intIterator = this.tuples.iterator();
        while (intIterator.hasNext()) {
            intSet.add(tupleFactory.project(intIterator.next(), this.arity, n));
        }
        return new TupleSet(this.universe, 1, intSet);
    }

    public TupleSet clone() {
        return new TupleSet(this);
    }

    @Override
    public Iterator<Tuple> iterator() {
        return new Iterator<Tuple>(){
            IntIterator indexIter;
            {
                this.indexIter = TupleSet.this.tuples.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.indexIter.hasNext();
            }

            @Override
            public Tuple next() {
                return TupleSet.this.universe.factory().tuple(TupleSet.this.arity, this.indexIter.next());
            }

            @Override
            public void remove() {
                this.indexIter.remove();
            }
        };
    }

    private final int extractIndex(Tuple tuple) {
        if (tuple.arity() != this.arity || !tuple.universe().equals(this.universe)) {
            throw new IllegalArgumentException("t.arity != this.arity || t.universe != this.universe");
        }
        return tuple.index();
    }

    @Override
    public boolean contains(Object object) {
        return this.tuples.contains(this.extractIndex((Tuple)object));
    }

    @Override
    public int size() {
        return this.tuples.size();
    }

    @Override
    public void clear() {
        this.tuples.clear();
    }

    @Override
    public boolean add(Tuple tuple) {
        return this.tuples.add(this.extractIndex(tuple));
    }

    @Override
    public boolean remove(Object object) {
        return this.tuples.remove(this.extractIndex((Tuple)object));
    }

    private IntSet extractTuples(Collection<?> collection) {
        if (collection instanceof TupleSet) {
            TupleSet tupleSet = (TupleSet)collection;
            if (this.arity != tupleSet.arity()) {
                throw new IllegalArgumentException("this.arity!=c.arity");
            }
            return this.universe.equals(tupleSet.universe()) ? tupleSet.tuples : null;
        }
        return null;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        IntSet intSet = this.extractTuples(collection);
        return intSet == null ? super.containsAll(collection) : this.tuples.containsAll(intSet);
    }

    @Override
    public boolean addAll(Collection<? extends Tuple> collection) {
        IntSet intSet = this.extractTuples(collection);
        return intSet == null ? super.addAll(collection) : this.tuples.addAll(intSet);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        IntSet intSet = this.extractTuples(collection);
        return intSet == null ? super.removeAll(collection) : this.tuples.removeAll(intSet);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        IntSet intSet = this.extractTuples(collection);
        return intSet == null ? super.retainAll(collection) : this.tuples.retainAll(intSet);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TupleSet) {
            TupleSet tupleSet = (TupleSet)object;
            return this.arity == tupleSet.arity && this.universe.equals(tupleSet.universe) && ((Object)this.tuples).equals(tupleSet.tuples);
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return ((Object)this.tuples).hashCode();
    }
}

