/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class CacheSet<E>
extends AbstractSet<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private Entry<E>[] table;
    private int size;
    private int threshold;
    final float loadFactor;

    public CacheSet() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
    }

    public CacheSet(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
    }

    public CacheSet(Collection<? extends E> collection) {
        this(collection.size(), 0.75f);
        this.addAll(collection);
    }

    private static int hash(int n) {
        n += ~(n << 9);
        n ^= n >>> 14;
        n += n << 4;
        n ^= n >>> 10;
        return n;
    }

    private static int hash(Object object) {
        return CacheSet.hash(object.hashCode());
    }

    private static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object object) {
        Entry<Object> entry = this.table[CacheSet.indexFor(CacheSet.hash(object), this.table.length)];
        while (entry != null) {
            if (entry.val.equals(object)) {
                return true;
            }
            entry = entry.next;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new SetIterator();
    }

    @Override
    public boolean add(E e) {
        int n = CacheSet.indexFor(CacheSet.hash(e), this.table.length);
        Entry<Object> entry = this.table[n];
        while (entry != null) {
            if (entry.val.equals(e)) {
                return false;
            }
            entry = entry.next;
        }
        this.table[n] = new Entry<E>(e, this.table[n]);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return true;
    }

    private void resize(int n) {
        Entry<E>[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    private void transfer(Entry<E>[] entryArray) {
        Entry<E>[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry<Object> entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = CacheSet.indexFor(CacheSet.hash(entry2.val), n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    @Override
    public boolean remove(Object object) {
        Entry<E> entry;
        int n = CacheSet.indexFor(CacheSet.hash(object), this.table.length);
        Entry<Object> entry2 = entry = this.table[n];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (entry2.val.equals(object)) {
                --this.size;
                if (entry == entry2) {
                    this.table[n] = entry3;
                } else {
                    entry.next = entry3;
                }
                return true;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return false;
    }

    public Iterator<E> get(final int n) {
        final int n2 = CacheSet.indexFor(CacheSet.hash(n), this.table.length);
        return new Iterator<E>(){
            Entry<E> current = null;
            Entry<E> next = CacheSet.access$000(CacheSet.this)[n2];

            @Override
            public boolean hasNext() {
                while (this.next != null && this.next.val.hashCode() != n) {
                    this.next = this.next.next;
                }
                return this.next != null;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.current = this.next;
                this.next = this.next.next;
                return this.current.val;
            }

            @Override
            public void remove() {
                Entry entry;
                if (this.current == null) {
                    throw new IllegalStateException();
                }
                Entry entry2 = entry = CacheSet.this.table[n2];
                while (entry2.next != this.current) {
                    entry = entry2;
                    entry2 = entry2.next;
                }
                CacheSet.this.size--;
                if (entry == entry2) {
                    ((CacheSet)CacheSet.this).table[n2] = this.next;
                } else {
                    entry.next = this.next;
                }
                this.current = null;
            }
        };
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    private final class SetIterator
    implements Iterator<E> {
        Entry<E> next;
        int index;
        Entry<E> current;

        SetIterator() {
            this.index = CacheSet.this.table.length;
            this.next = null;
            if (CacheSet.this.size != 0) {
                while (this.index > 0 && (this.next = CacheSet.this.table[--this.index]) == null) {
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            Entry entry = this.next;
            if (entry == null) {
                throw new NoSuchElementException();
            }
            Entry entry2 = entry.next;
            while (entry2 == null && this.index > 0) {
                entry2 = CacheSet.this.table[--this.index];
            }
            this.next = entry2;
            this.current = entry;
            return this.current.val;
        }

        @Override
        public void remove() {
            if (this.current == null) {
                throw new IllegalStateException();
            }
            CacheSet.this.remove(this.current.val);
            this.current = null;
        }
    }

    private static final class Entry<T> {
        Entry<T> next;
        T val;

        Entry(T t, Entry<T> entry) {
            this.val = t;
            this.next = entry;
        }
    }
}

