/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IdentityHashSet<T>
extends AbstractSet<T> {
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private static final Object NULL = new Object();
    private Object[] table;
    private int size;
    private int threshold;

    private static Object maskNull(Object object) {
        return object == null ? NULL : object;
    }

    private static Object unmaskNull(Object object) {
        return object == NULL ? null : object;
    }

    public IdentityHashSet() {
        this(16);
    }

    public IdentityHashSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("expectedMaxSize < 0: " + n);
        }
        int n2 = IdentityHashSet.capacity(n);
        this.threshold = n2 * 2 / 3;
        this.table = new Object[n2];
        this.size = 0;
    }

    public IdentityHashSet(Collection<? extends T> collection) {
        this((int)((double)(1 + collection.size()) * 1.1));
        this.addAll(collection);
    }

    private static int capacity(int n) {
        int n2;
        int n3 = 3 * n / 2;
        if (n3 > 0x20000000 || n3 < 0) {
            n2 = 0x20000000;
        } else {
            n2 = StrictMath.max(4, Integer.highestOneBit(n3));
            if (n2 < n3) {
                n2 <<= 1;
            }
        }
        return n2;
    }

    @Override
    public Iterator<T> iterator() {
        return new IdentityIterator();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(Object object, int n) {
        return System.identityHashCode(object) & n - 1;
    }

    private static int nextKeyIndex(int n, int n2) {
        return n + 3 & n2 - 1;
    }

    @Override
    public boolean contains(Object object) {
        object = IdentityHashSet.maskNull(object);
        int n = IdentityHashSet.hash(object, this.table.length);
        Object object2;
        while ((object2 = this.table[n]) != object) {
            if (object2 == null) {
                return false;
            }
            n = IdentityHashSet.nextKeyIndex(n, this.table.length);
        }
        return true;
    }

    @Override
    public boolean add(T t) {
        Object object = IdentityHashSet.maskNull(t);
        int n = IdentityHashSet.hash(object, this.table.length);
        Object object2 = this.table[n];
        while (object2 != null) {
            if (object2 == object) {
                return false;
            }
            n = IdentityHashSet.nextKeyIndex(n, this.table.length);
            object2 = this.table[n];
        }
        this.table[n] = object;
        if (++this.size >= this.threshold) {
            this.resize(this.table.length << 1);
        }
        return true;
    }

    private void resize(int n) {
        int n2 = this.table.length;
        if (n2 == 0x20000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (n2 >= n) {
            return;
        }
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n2; ++i) {
            Object object = this.table[i];
            if (object == null) continue;
            this.table[i] = null;
            int n3 = IdentityHashSet.hash(object, n);
            while (objectArray[n3] != null) {
                n3 = IdentityHashSet.nextKeyIndex(n3, n);
            }
            objectArray[n3] = object;
        }
        this.table = objectArray;
        this.threshold = n * 2 / 3;
    }

    @Override
    public boolean remove(Object object) {
        object = IdentityHashSet.maskNull(object);
        int n = IdentityHashSet.hash(object, this.table.length);
        while (true) {
            Object object2;
            if ((object2 = this.table[n]) == object) {
                --this.size;
                this.table[n] = null;
                this.closeDeletion(n);
                return true;
            }
            if (object2 == null) {
                return false;
            }
            n = IdentityHashSet.nextKeyIndex(n, this.table.length);
        }
    }

    private void closeDeletion(int n) {
        Object object;
        int n2 = IdentityHashSet.nextKeyIndex(n, this.table.length);
        while ((object = this.table[n2]) != null) {
            int n3 = IdentityHashSet.hash(object, this.table.length);
            if (n2 < n3 && (n3 <= n || n <= n2) || n3 <= n && n <= n2) {
                this.table[n] = object;
                this.table[n2] = null;
                n = n2;
            }
            n2 = IdentityHashSet.nextKeyIndex(n2, this.table.length);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        int n = collection.size();
        if (n == 0) {
            return false;
        }
        if (n > this.threshold) {
            this.resize(IdentityHashSet.capacity(n));
        }
        return super.addAll(collection);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (!collection.contains(iterator.next())) continue;
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    @Override
    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IdentityHashSet) {
            IdentityHashSet identityHashSet = (IdentityHashSet)object;
            if (identityHashSet.size() != this.size) {
                return false;
            }
            Object[] objectArray = identityHashSet.table;
            for (int i = 0; i < objectArray.length; ++i) {
                Object object2 = objectArray[i];
                if (object2 == null || this.contains(object2)) continue;
                return false;
            }
            return true;
        }
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        int n = 0;
        for (Object object : this.table) {
            if (object == null) continue;
            n += System.identityHashCode(IdentityHashSet.unmaskNull(object));
        }
        return n;
    }

    private final class IdentityIterator
    implements Iterator<T> {
        int index;
        int lastReturnedIndex;
        Object[] traversalTable;

        private IdentityIterator() {
            this.index = IdentityHashSet.this.size != 0 ? 0 : IdentityHashSet.this.table.length;
            this.lastReturnedIndex = -1;
            this.traversalTable = IdentityHashSet.this.table;
        }

        @Override
        public boolean hasNext() {
            for (int i = this.index; i < this.traversalTable.length; ++i) {
                if (this.traversalTable[i] == null) continue;
                this.index = i;
                return true;
            }
            this.index = this.traversalTable.length;
            return false;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturnedIndex = this.index++;
            return IdentityHashSet.unmaskNull(this.traversalTable[this.lastReturnedIndex]);
        }

        @Override
        public void remove() {
            if (this.lastReturnedIndex == -1) {
                throw new IllegalStateException();
            }
            int n = this.lastReturnedIndex;
            this.lastReturnedIndex = -1;
            if (this.traversalTable != IdentityHashSet.this.table) {
                IdentityHashSet.this.remove(this.traversalTable[n]);
                this.traversalTable[n] = null;
            } else {
                Object object;
                IdentityHashSet.this.size--;
                this.index = n;
                Object[] objectArray = this.traversalTable;
                int n2 = objectArray.length;
                int n3 = n;
                objectArray[n3] = null;
                int n4 = IdentityHashSet.nextKeyIndex(n3, n2);
                while ((object = objectArray[n4]) != null) {
                    int n5 = IdentityHashSet.hash(object, n2);
                    if (n4 < n5 && (n5 <= n3 || n3 <= n4) || n5 <= n3 && n3 <= n4) {
                        if (n4 < n && n3 >= n && this.traversalTable == IdentityHashSet.this.table) {
                            int n6 = n2 - n;
                            Object[] objectArray2 = new Object[n6];
                            System.arraycopy(objectArray, n, objectArray2, 0, n6);
                            this.traversalTable = objectArray2;
                            this.index = 0;
                        }
                        objectArray[n3] = object;
                        objectArray[n4] = null;
                        n3 = n4;
                    }
                    n4 = IdentityHashSet.nextKeyIndex(n4, n2);
                }
            }
        }
    }
}

