/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kodkod.util.collections.Containers;

public final class SingletonIdentitySet<V>
extends AbstractSet<V> {
    private final V element;

    public SingletonIdentitySet(V v) {
        this.element = v;
    }

    public SingletonIdentitySet(Collection<? extends V> collection) {
        this.element = collection.iterator().next();
    }

    @Override
    public boolean contains(Object object) {
        return this.element == object;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        if (collection.size() == 1) {
            return collection.iterator().next() == this.element;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public Iterator<V> iterator() {
        return Containers.iterate(this.element);
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Set) {
            Set set = (Set)object;
            return set.size() == 1 && set.iterator().next() == this.element;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.element == null ? 0 : this.element.hashCode();
    }
}

