/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.NoSuchElementException;
import kodkod.util.ints.AbstractIntCollection;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

public abstract class AbstractIntSet
extends AbstractIntCollection
implements IntSet {
    protected AbstractIntSet() {
    }

    final void checkNonEmpty() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("no this.ints");
        }
    }

    @Override
    public IntIterator iterator() {
        return this.iterator(Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public int min() {
        return this.iterator().next();
    }

    @Override
    public int max() {
        return this.iterator(Integer.MAX_VALUE, Integer.MIN_VALUE).next();
    }

    @Override
    public IntSet clone() throws CloneNotSupportedException {
        return (IntSet)super.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof IntSet) {
            IntSet intSet = (IntSet)object;
            return this.size() == intSet.size() && this.containsAll(intSet);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = this.size();
        IntIterator intIterator = this.iterator();
        while (intIterator.hasNext()) {
            n = Ints.superFastHashIncremental(intIterator.next(), n);
        }
        return Ints.superFastHashAvalanche(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        IntIterator intIterator = this.iterator();
        if (intIterator.hasNext()) {
            stringBuilder.append(intIterator.next());
        }
        while (intIterator.hasNext()) {
            stringBuilder.append(", ");
            stringBuilder.append(intIterator.next());
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

