/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.Arrays;
import java.util.NoSuchElementException;
import kodkod.util.ints.AbstractIntSet;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.Ints;

public final class ArrayIntSet
extends AbstractIntSet {
    private final int[] ints;
    private final int hashcode;

    public ArrayIntSet(int[] nArray) {
        this.ints = nArray;
        this.hashcode = Ints.superFastHash(nArray);
    }

    public ArrayIntSet(IntSet intSet) {
        this(intSet.toArray());
    }

    @Override
    public IntIterator iterator(int n, int n2) {
        return n <= n2 ? new AscendingIntArrayIterator(n, n2) : new DescendingIntArrayIterator(n, n2);
    }

    @Override
    public int size() {
        return this.ints.length;
    }

    @Override
    public int ceil(int n) {
        int n2 = Arrays.binarySearch(this.ints, n);
        if (n2 == -this.ints.length - 1) {
            throw new NoSuchElementException();
        }
        return n2 >= 0 ? this.ints[n2] : this.ints[-n2 - 1];
    }

    @Override
    public int floor(int n) {
        int n2 = Arrays.binarySearch(this.ints, n);
        if (n2 == -1) {
            throw new NoSuchElementException();
        }
        return n2 >= 0 ? this.ints[n2] : this.ints[-n2 - 2];
    }

    @Override
    public boolean contains(int n) {
        return Arrays.binarySearch(this.ints, n) >= 0;
    }

    @Override
    public int max() {
        if (this.ints.length == 0) {
            throw new NoSuchElementException();
        }
        return this.ints[this.ints.length - 1];
    }

    @Override
    public int min() {
        if (this.ints.length == 0) {
            throw new NoSuchElementException();
        }
        return this.ints[0];
    }

    @Override
    public int[] toArray() {
        int[] nArray = new int[this.ints.length];
        System.arraycopy(this.ints, 0, nArray, 0, this.ints.length);
        return nArray;
    }

    @Override
    public int[] toArray(int[] nArray) {
        if (nArray.length < this.size()) {
            nArray = new int[this.ints.length];
        }
        System.arraycopy(this.ints, 0, nArray, 0, this.ints.length);
        return nArray;
    }

    @Override
    public int hashCode() {
        return this.hashcode;
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof ArrayIntSet ? Arrays.equals(this.ints, ((ArrayIntSet)object).ints) : super.equals(object);
    }

    private final class DescendingIntArrayIterator
    implements IntIterator {
        private int next;
        private int end;

        DescendingIntArrayIterator(int n, int n2) {
            int n3 = Arrays.binarySearch(ArrayIntSet.this.ints, n);
            int n4 = Arrays.binarySearch(ArrayIntSet.this.ints, n2);
            this.next = n3 >= 0 ? n3 : -n3 - 2;
            this.end = n4 >= 0 ? n4 : -n4 - 1;
        }

        @Override
        public boolean hasNext() {
            return this.next >= this.end;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ArrayIntSet.this.ints[this.next--];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private final class AscendingIntArrayIterator
    implements IntIterator {
        private int next;
        private int end;

        AscendingIntArrayIterator(int n, int n2) {
            int n3 = Arrays.binarySearch(ArrayIntSet.this.ints, n);
            int n4 = Arrays.binarySearch(ArrayIntSet.this.ints, n2);
            this.next = n3 >= 0 ? n3 : -n3 - 1;
            this.end = n4 >= 0 ? n4 : -n4 - 2;
        }

        @Override
        public boolean hasNext() {
            return this.next >= 0 && this.next <= this.end;
        }

        @Override
        public int next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return ArrayIntSet.this.ints[this.next++];
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

