/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import kodkod.util.ints.AbstractIntVector;
import kodkod.util.ints.IntCollection;
import kodkod.util.ints.IntIterator;

public final class ArrayIntVector
extends AbstractIntVector {
    private int[] elements;
    private int size;

    public ArrayIntVector(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        this.elements = new int[n];
    }

    public ArrayIntVector() {
        this(10);
    }

    public ArrayIntVector(int[] nArray) {
        this.size = nArray.length;
        int n = (int)Math.min((long)this.size * 110L / 100L, Integer.MAX_VALUE);
        this.elements = new int[n];
        System.arraycopy(nArray, 0, this.elements, 0, this.size);
    }

    public void trimToSize() {
        int n = this.elements.length;
        if (this.size < n) {
            int[] nArray = this.elements;
            this.elements = new int[this.size];
            System.arraycopy(nArray, 0, this.elements, 0, this.size);
        }
    }

    public void ensureCapacity(int n) {
        int n2 = this.elements.length;
        if (n > n2) {
            int[] nArray = this.elements;
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elements = new int[n3];
            System.arraycopy(nArray, 0, this.elements, 0, this.size);
        }
    }

    private void checkExcludeLength(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkIncludeLength(int n) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public int get(int n) {
        this.checkExcludeLength(n);
        return this.elements[n];
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int set(int n, int n2) {
        int n3 = this.get(n);
        this.elements[n] = n2;
        return n3;
    }

    @Override
    public boolean add(int n) {
        this.ensureCapacity(this.size + 1);
        this.elements[this.size++] = n;
        return true;
    }

    @Override
    public void add(int n, int n2) {
        this.checkIncludeLength(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.elements, n, this.elements, n + 1, this.size - n);
        this.elements[n] = n2;
        ++this.size;
    }

    @Override
    public boolean addAll(int n, IntCollection intCollection) {
        this.checkIncludeLength(n);
        int n2 = intCollection.size();
        if (n2 == 0) {
            return false;
        }
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.elements, n, this.elements, n + n2, this.size - n);
        IntIterator intIterator = intCollection.iterator();
        while (intIterator.hasNext()) {
            this.elements[n++] = intIterator.next();
        }
        return true;
    }

    @Override
    public int removeAt(int n) {
        this.checkExcludeLength(n);
        int n2 = this.elements[n];
        System.arraycopy(this.elements, n + 1, this.elements, n, this.size - n - 1);
        --this.size;
        return n2;
    }

    @Override
    public int[] toArray(int[] nArray) {
        if (nArray.length < this.size) {
            nArray = new int[this.size];
        }
        System.arraycopy(this.elements, 0, nArray, 0, this.size);
        return nArray;
    }
}

