/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

final class IntTree<N extends Node<N>>
implements Cloneable {
    private static final boolean BLACK = true;
    private static final boolean RED = false;
    private N root = null;

    IntTree() {
    }

    final void clear() {
        this.root = null;
    }

    final N search(int n) {
        Object object = this.root;
        while (object != null && ((Node)object).key != n) {
            if (((Node)object).key > n) {
                object = ((Node)object).left;
                continue;
            }
            object = ((Node)object).right;
        }
        return object;
    }

    final N searchGTE(int n) {
        if (this.root == null) {
            return null;
        }
        Object object = this.root;
        while (true) {
            if (((Node)object).key == n) {
                return object;
            }
            if (((Node)object).key > n) {
                if (((Node)object).left != null) {
                    object = ((Node)object).left;
                    continue;
                }
                return object;
            }
            if (((Node)object).right == null) break;
            object = ((Node)object).right;
        }
        return this.successor(object);
    }

    final N searchLTE(int n) {
        if (this.root == null) {
            return null;
        }
        Object object = this.root;
        while (true) {
            if (((Node)object).key == n) {
                return object;
            }
            if (((Node)object).key > n) {
                if (((Node)object).left != null) {
                    object = ((Node)object).left;
                    continue;
                }
                return this.predecessor(object);
            }
            if (((Node)object).right == null) break;
            object = ((Node)object).right;
        }
        return object;
    }

    final N predecessor(N n) {
        if (((Node)n).left != null) {
            return (N)this.max(((Node)n).left);
        }
        Object object = n;
        Node node = ((Node)object).parent;
        while (node != null && object == node.left) {
            object = node;
            node = node.parent;
        }
        return (N)node;
    }

    final N successor(N n) {
        if (((Node)n).right != null) {
            return (N)this.min(((Node)n).right);
        }
        Object object = n;
        Node node = ((Node)object).parent;
        while (node != null && object == node.right) {
            object = node;
            node = node.parent;
        }
        return (N)node;
    }

    final N min() {
        return this.min(this.root);
    }

    final N max() {
        return this.max(this.root);
    }

    private final N min(N object) {
        if (object != null) {
            while (((Node)object).left != null) {
                object = ((Node)object).left;
            }
        }
        return object;
    }

    private final N max(N object) {
        if (object != null) {
            while (((Node)object).right != null) {
                object = ((Node)object).right;
            }
        }
        return object;
    }

    final void replace(N n, N n2) {
        ((Node)n2).color = ((Node)n).color;
        ((Node)n2).parent = (Node)((Node)n).parent;
        ((Node)n2).left = (Node)((Node)n).left;
        ((Node)n2).right = (Node)((Node)n).right;
        if (((Node)n).left != null) {
            ((Node)((Node)n).left).parent = (Node)n2;
        }
        if (((Node)n).right != null) {
            ((Node)((Node)n).right).parent = (Node)n2;
        }
        if (((Node)n).parent == null) {
            this.root = n2;
        } else if (n == ((Node)((Node)n).parent).left) {
            ((Node)((Node)n).parent).left = (Node)n2;
        } else {
            ((Node)((Node)n).parent).right = (Node)n2;
        }
        ((Node)n).parent = (Node)(((Node)n).left = (Node)(((Node)n).right = null));
    }

    private final N parentOf(N n) {
        return (N)(n == null ? null : ((Node)n).parent);
    }

    private final N leftOf(N n) {
        return (N)(n == null ? null : ((Node)n).left);
    }

    private final N rightOf(N n) {
        return (N)(n == null ? null : ((Node)n).right);
    }

    private final boolean colorOf(N n) {
        return n == null ? true : ((Node)n).color;
    }

    private final void setColor(N n, boolean bl) {
        if (n != null) {
            ((Node)n).color = bl;
        }
    }

    final void insert(N n) {
        Node node = null;
        Object object = this.root;
        while (object != null) {
            node = (Node)object;
            if (((Node)object).key > ((Node)n).key) {
                object = ((Node)object).left;
                continue;
            }
            object = ((Node)object).right;
        }
        ((Node)n).parent = node;
        ((Node)n).left = (Node)(((Node)n).right = null);
        if (node == null) {
            this.root = n;
        } else {
            ((Node)n).color = false;
            if (node.key > ((Node)n).key) {
                node.left = (Node)n;
            } else {
                node.right = (Node)n;
            }
            this.insertFixUp(n);
        }
    }

    final void delete(N n) {
        N n2 = ((Node)n).left == null || ((Node)n).right == null ? n : this.successor(n);
        Node node = ((Node)n2).left != null ? ((Node)n2).left : ((Node)n2).right;
        Node node2 = ((Node)n2).parent;
        boolean bl = n2 == this.leftOf(((Node)n2).parent);
        boolean bl2 = ((Node)n2).color;
        if (node != null) {
            node.parent = node2;
        }
        if (node2 == null) {
            this.root = node;
        } else if (bl) {
            node2.left = node;
        } else {
            node2.right = node;
        }
        if (n2 != n) {
            this.replace(n, n2);
        }
        if (bl2) {
            if (node != null) {
                this.deleteFixUp(node);
            } else if (node2 != null) {
                if (n == node2) {
                    node2 = n2;
                }
                ((Node)n).color = true;
                ((Node)n).left = (Node)(((Node)n).right = null);
                ((Node)n).parent = node2;
                if (bl) {
                    node2.left = (Node)n;
                } else {
                    node2.right = (Node)n;
                }
                this.deleteFixUp(n);
                if (n == ((Node)((Node)n).parent).left) {
                    ((Node)((Node)n).parent).left = null;
                } else {
                    ((Node)((Node)n).parent).right = null;
                }
            }
        }
        ((Node)n).left = (Node)(((Node)n).right = (Node)(((Node)n).parent = null));
    }

    protected IntTree<N> clone() throws CloneNotSupportedException {
        IntTree intTree = (IntTree)super.clone();
        intTree.root = this.clone(this.root, null);
        return intTree;
    }

    private N clone(N n, N n2) throws CloneNotSupportedException {
        if (n == null) {
            return null;
        }
        Object object = ((Node)n).clone();
        ((Node)object).parent = (Node)n2;
        ((Node)object).left = (Node)this.clone(((Node)n).left, object);
        ((Node)object).right = (Node)this.clone(((Node)n).right, object);
        return (N)object;
    }

    private void insertFixUp(N n) {
        while (n != null && n != this.root && !((Node)((Node)n).parent).color) {
            N n2;
            if (this.parentOf(n) == this.leftOf(this.parentOf(this.parentOf(n)))) {
                n2 = this.rightOf(this.parentOf(this.parentOf(n)));
                if (!this.colorOf(n2)) {
                    this.setColor(this.parentOf(n), true);
                    this.setColor(n2, true);
                    this.setColor(this.parentOf(this.parentOf(n)), false);
                    n = this.parentOf(this.parentOf(n));
                    continue;
                }
                if (n == this.rightOf(this.parentOf(n))) {
                    n = this.parentOf(n);
                    this.rotateLeft(n);
                }
                this.setColor(this.parentOf(n), true);
                this.setColor(this.parentOf(this.parentOf(n)), false);
                if (this.parentOf(this.parentOf(n)) == null) continue;
                this.rotateRight(this.parentOf(this.parentOf(n)));
                continue;
            }
            n2 = this.leftOf(this.parentOf(this.parentOf(n)));
            if (!this.colorOf(n2)) {
                this.setColor(this.parentOf(n), true);
                this.setColor(n2, true);
                this.setColor(this.parentOf(this.parentOf(n)), false);
                n = this.parentOf(this.parentOf(n));
                continue;
            }
            if (n == this.leftOf(this.parentOf(n))) {
                n = this.parentOf(n);
                this.rotateRight(n);
            }
            this.setColor(this.parentOf(n), true);
            this.setColor(this.parentOf(this.parentOf(n)), false);
            if (this.parentOf(this.parentOf(n)) == null) continue;
            this.rotateLeft(this.parentOf(this.parentOf(n)));
        }
        ((Node)this.root).color = true;
    }

    private void deleteFixUp(N n) {
        while (n != this.root && this.colorOf(n)) {
            N n2;
            if (n == this.leftOf(this.parentOf(n))) {
                n2 = this.rightOf(this.parentOf(n));
                if (!this.colorOf(n2)) {
                    this.setColor(n2, true);
                    this.setColor(this.parentOf(n), false);
                    this.rotateLeft(this.parentOf(n));
                    n2 = this.rightOf(this.parentOf(n));
                }
                if (this.colorOf(this.leftOf(n2)) && this.colorOf(this.rightOf(n2))) {
                    this.setColor(n2, false);
                    n = this.parentOf(n);
                    continue;
                }
                if (this.colorOf(this.rightOf(n2))) {
                    this.setColor(this.leftOf(n2), true);
                    this.setColor(n2, false);
                    this.rotateRight(n2);
                    n2 = this.rightOf(this.parentOf(n));
                }
                this.setColor(n2, this.colorOf(this.parentOf(n)));
                this.setColor(this.parentOf(n), true);
                this.setColor(this.rightOf(n2), true);
                this.rotateLeft(this.parentOf(n));
                n = this.root;
                continue;
            }
            n2 = this.leftOf(this.parentOf(n));
            if (!this.colorOf(n2)) {
                this.setColor(n2, true);
                this.setColor(this.parentOf(n), false);
                this.rotateRight(this.parentOf(n));
                n2 = this.leftOf(this.parentOf(n));
            }
            if (this.colorOf(this.rightOf(n2)) && this.colorOf(this.leftOf(n2))) {
                this.setColor(n2, false);
                n = this.parentOf(n);
                continue;
            }
            if (this.colorOf(this.leftOf(n2))) {
                this.setColor(this.rightOf(n2), true);
                this.setColor(n2, false);
                this.rotateLeft(n2);
                n2 = this.leftOf(this.parentOf(n));
            }
            this.setColor(n2, this.colorOf(this.parentOf(n)));
            this.setColor(this.parentOf(n), true);
            this.setColor(this.leftOf(n2), true);
            this.rotateRight(this.parentOf(n));
            n = this.root;
        }
        this.setColor(n, true);
    }

    private void rotateLeft(N n) {
        Node node = ((Node)n).right;
        ((Node)n).right = (Node)node.left;
        if (node.left != null) {
            ((Node)node.left).parent = (Node)n;
        }
        node.parent = (Node)((Node)n).parent;
        if (((Node)n).parent == null) {
            this.root = node;
        } else if (((Node)((Node)n).parent).left == n) {
            ((Node)((Node)n).parent).left = node;
        } else {
            ((Node)((Node)n).parent).right = node;
        }
        node.left = (Node)n;
        ((Node)n).parent = node;
    }

    private void rotateRight(N n) {
        Node node = ((Node)n).left;
        ((Node)n).left = (Node)node.right;
        if (node.right != null) {
            ((Node)node.right).parent = (Node)n;
        }
        node.parent = (Node)((Node)n).parent;
        if (((Node)n).parent == null) {
            this.root = node;
        } else if (((Node)((Node)n).parent).right == n) {
            ((Node)((Node)n).parent).right = node;
        } else {
            ((Node)((Node)n).parent).left = node;
        }
        node.right = (Node)n;
        ((Node)n).parent = node;
    }

    public String toString() {
        return ((Node)this.root).toString();
    }

    static abstract class Node<N extends Node<N>>
    implements Cloneable {
        private N parent = null;
        private N left = null;
        private N right = null;
        private boolean color = true;
        protected int key;

        Node(int n) {
            this.key = n;
        }

        final N left() {
            return this.left;
        }

        final N right() {
            return this.right;
        }

        final N parent() {
            return this.parent;
        }

        protected Node<N> clone() throws CloneNotSupportedException {
            Node node = (Node)super.clone();
            node.right = null;
            node.left = null;
            node.parent = null;
            return node;
        }

        public String toString() {
            return "[" + this.key + " " + (this.color ? "b" : "r") + " " + (this.left == this ? Integer.valueOf(this.key) : this.left) + " " + (this.right == this ? Integer.valueOf(this.key) : this.right) + "]";
        }
    }
}

