/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kodkod.util.ints.AbstractIntSet;
import kodkod.util.ints.AbstractIntVector;
import kodkod.util.ints.AbstractSparseSequence;
import kodkod.util.ints.ArrayIntSet;
import kodkod.util.ints.IndexedEntry;
import kodkod.util.ints.IntBitSet;
import kodkod.util.ints.IntIterator;
import kodkod.util.ints.IntRange;
import kodkod.util.ints.IntSet;
import kodkod.util.ints.IntTreeSet;
import kodkod.util.ints.IntVector;
import kodkod.util.ints.SparseSequence;

public final class Ints {
    private static final int BITSET_CUTOFF = 1024;
    public static final IntSet EMPTY_SET = new AbstractIntSet(){

        @Override
        public boolean contains(int n) {
            return false;
        }

        @Override
        public int min() {
            throw new NoSuchElementException();
        }

        @Override
        public int max() {
            throw new NoSuchElementException();
        }

        @Override
        public IntIterator iterator(int n, int n2) {
            return new IntIterator(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public int next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int floor(int n) {
            throw new NoSuchElementException();
        }

        @Override
        public int ceil(int n) {
            throw new NoSuchElementException();
        }

        @Override
        public IntSet clone() {
            return EMPTY_SET;
        }
    };

    private Ints() {
    }

    public static IntRange range(int n, int n2) {
        if (n < n2) {
            return new IntRange.TwoPointRange(n, n2);
        }
        if (n == n2) {
            return new IntRange.OnePointRange(n);
        }
        throw new IllegalArgumentException("min > max");
    }

    public static IntRange merge(IntRange intRange, IntRange intRange2) {
        if (intRange.contains(intRange2)) {
            return intRange;
        }
        if (intRange2.contains(intRange)) {
            return intRange2;
        }
        return Ints.range(StrictMath.min(intRange.min(), intRange2.min()), StrictMath.max(intRange.max(), intRange2.max()));
    }

    public static IntSet unmodifiableIntSet(IntSet intSet) {
        if (intSet == null) {
            throw new NullPointerException("s = null");
        }
        if (intSet instanceof UnmodifiableIntSet || intSet instanceof SingletonIntSet || intSet instanceof RangeIntSet) {
            return intSet;
        }
        return new UnmodifiableIntSet(intSet);
    }

    public static IntSet singleton(int n) {
        return new SingletonIntSet(n);
    }

    public static IntSet rangeSet(IntRange intRange) {
        if (intRange == null) {
            throw new NullPointerException();
        }
        return new RangeIntSet(intRange);
    }

    public static IntSet bestSet(int n) {
        return n > 1024 ? new IntTreeSet() : new IntBitSet(n);
    }

    public static IntSet bestSet(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException("min > max");
        }
        return n < 0 ? new IntTreeSet() : Ints.bestSet(n2 + 1);
    }

    public static IntSet asSet(int[] nArray) {
        return nArray.length == 0 ? EMPTY_SET : new ArrayIntSet(nArray);
    }

    public static IntVector asIntVector(final int[] nArray) {
        return new AbstractIntVector(){

            @Override
            public int get(int n) {
                return nArray[n];
            }

            @Override
            public int size() {
                return nArray.length;
            }

            @Override
            public int[] toArray(int[] nArray2) {
                if (nArray2.length < nArray.length) {
                    nArray2 = new int[nArray.length];
                }
                System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
                return nArray2;
            }
        };
    }

    public static IntVector nCopies(final int n, final int n2) {
        return new AbstractIntVector(){

            @Override
            public int get(int n3) {
                if (n3 < 0 || n3 >= n) {
                    throw new IndexOutOfBoundsException();
                }
                return n2;
            }

            @Override
            public int size() {
                return n;
            }

            @Override
            public int[] toArray(int[] nArray) {
                if (nArray.length < n) {
                    nArray = new int[n];
                }
                for (int i = 0; i < n; ++i) {
                    nArray[i] = n2;
                }
                return nArray;
            }
        };
    }

    public static <V> SparseSequence<V> unmodifiableSequence(SparseSequence<V> sparseSequence) {
        if (sparseSequence == null) {
            throw new NullPointerException();
        }
        if (sparseSequence instanceof UnmodifiableSparseSequence) {
            return sparseSequence;
        }
        return new UnmodifiableSparseSequence<V>(sparseSequence);
    }

    private static int low16(int n) {
        return n & 0xFFFF;
    }

    private static int high16(int n) {
        return Ints.low16(n >>> 16);
    }

    public static int superFastHashAvalanche(int n) {
        n ^= n << 3;
        n += n >> 5;
        n ^= n << 4;
        n += n >> 17;
        n ^= n << 25;
        n += n >> 6;
        return n;
    }

    public static int superFastHashIncremental(int n, int n2) {
        int n3 = Ints.high16(n) << 11 ^ (n2 += Ints.low16(n));
        n2 = n2 << 16 ^ n3;
        n2 += n2 >> 11;
        return n2;
    }

    public static int superFastHash(int n) {
        return Ints.superFastHashAvalanche(Ints.superFastHashIncremental(n, 11));
    }

    public static int superFastHash(int ... nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        int n = nArray.length;
        for (int n2 : nArray) {
            n = Ints.superFastHashIncremental(n2, n);
        }
        return Ints.superFastHashAvalanche(n);
    }

    public static int superFastHash(Object ... objectArray) {
        if (objectArray.length == 0) {
            return 0;
        }
        int n = objectArray.length;
        for (Object object : objectArray) {
            n = Ints.superFastHashIncremental(object == null ? 0 : object.hashCode(), n);
        }
        return Ints.superFastHashAvalanche(n);
    }

    private static final class UnmodifiableSparseSequence<V>
    extends AbstractSparseSequence<V> {
        private final SparseSequence<V> s;

        UnmodifiableSparseSequence(SparseSequence<V> sparseSequence) {
            this.s = sparseSequence;
        }

        @Override
        public Iterator<IndexedEntry<V>> iterator(final int n, final int n2) {
            return new Iterator<IndexedEntry<V>>(){
                Iterator<IndexedEntry<V>> iter;
                {
                    this.iter = UnmodifiableSparseSequence.this.s.iterator(n, n2);
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public IndexedEntry<V> next() {
                    return this.iter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public V put(int n, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V get(int n) {
            return this.s.get(n);
        }

        @Override
        public V remove(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public IndexedEntry<V> first() {
            return this.s.first();
        }

        @Override
        public IndexedEntry<V> last() {
            return this.s.last();
        }

        @Override
        public IndexedEntry<V> ceil(int n) {
            return this.s.ceil(n);
        }

        @Override
        public IndexedEntry<V> floor(int n) {
            return this.s.floor(n);
        }

        @Override
        public boolean containsIndex(int n) {
            return this.s.containsIndex(n);
        }

        @Override
        public boolean contains(Object object) {
            return this.s.contains(object);
        }

        @Override
        public SparseSequence<V> clone() throws CloneNotSupportedException {
            return this.s.clone();
        }
    }

    private static final class UnmodifiableIntSet
    extends AbstractIntSet {
        private final IntSet s;

        UnmodifiableIntSet(IntSet intSet) {
            this.s = intSet;
        }

        @Override
        public int size() {
            return this.s.size();
        }

        @Override
        public boolean contains(int n) {
            return this.s.contains(n);
        }

        @Override
        public int min() {
            return this.s.min();
        }

        @Override
        public int max() {
            return this.s.max();
        }

        @Override
        public IntIterator iterator(final int n, final int n2) {
            return new IntIterator(){
                IntIterator iter;
                {
                    this.iter = UnmodifiableIntSet.this.s.iterator(n, n2);
                }

                @Override
                public boolean hasNext() {
                    return this.iter.hasNext();
                }

                @Override
                public int next() {
                    return this.iter.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int floor(int n) {
            return this.s.floor(n);
        }

        @Override
        public int ceil(int n) {
            return this.s.ceil(n);
        }

        @Override
        public IntSet clone() throws CloneNotSupportedException {
            return this.s.clone();
        }
    }

    private static final class SingletonIntSet
    extends AbstractIntSet {
        private final int i;

        SingletonIntSet(int n) {
            this.i = n;
        }

        @Override
        public boolean contains(int n) {
            return this.i == n;
        }

        @Override
        public int min() {
            return this.i;
        }

        @Override
        public int max() {
            return this.i;
        }

        @Override
        public IntIterator iterator(final int n, final int n2) {
            return new IntIterator(){
                boolean cursor;
                {
                    this.cursor = n <= SingletonIntSet.this.i && SingletonIntSet.this.i <= n2 || n2 <= SingletonIntSet.this.i && SingletonIntSet.this.i <= n;
                }

                @Override
                public boolean hasNext() {
                    return this.cursor;
                }

                @Override
                public int next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.cursor = false;
                    return SingletonIntSet.this.i;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof IntSet) {
                IntSet intSet = (IntSet)object;
                return intSet.size() == 1 && intSet.min() == this.i;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            return this.i;
        }

        @Override
        public int floor(int n) {
            if (this.i <= n) {
                return this.i;
            }
            throw new NoSuchElementException();
        }

        @Override
        public int ceil(int n) {
            if (this.i >= n) {
                return this.i;
            }
            throw new NoSuchElementException();
        }

        @Override
        public IntSet clone() {
            return this;
        }
    }

    private static final class RangeIntSet
    extends AbstractIntSet {
        private final IntRange range;

        RangeIntSet(IntRange intRange) {
            this.range = intRange;
        }

        @Override
        public boolean contains(int n) {
            return this.range.contains(n);
        }

        @Override
        public int min() {
            return this.range.min();
        }

        @Override
        public int max() {
            return this.range.max();
        }

        @Override
        public IntIterator iterator(final int n, final int n2) {
            return new IntIterator(){
                final boolean ascending;
                long cursor;
                final int end;
                {
                    this.ascending = n <= n2;
                    this.cursor = this.ascending ? (long)StrictMath.max(RangeIntSet.this.range.min(), n) : (long)StrictMath.min(RangeIntSet.this.range.max(), n);
                    this.end = this.ascending ? StrictMath.min(RangeIntSet.this.range.max(), n2) : StrictMath.max(RangeIntSet.this.range.min(), n2);
                }

                @Override
                public boolean hasNext() {
                    return this.ascending && this.cursor <= (long)this.end || !this.ascending && this.cursor >= (long)this.end;
                }

                @Override
                public int next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return this.ascending ? (int)this.cursor++ : (int)this.cursor--;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public int size() {
            return this.range.size();
        }

        @Override
        public int floor(int n) {
            if (n < this.range.min()) {
                throw new NoSuchElementException();
            }
            return StrictMath.min(n, this.range.max());
        }

        @Override
        public int ceil(int n) {
            if (n > this.range.max()) {
                throw new NoSuchElementException();
            }
            return StrictMath.max(n, this.range.min());
        }

        @Override
        public IntSet clone() {
            return this;
        }
    }
}

