/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.ints;

import java.util.Iterator;
import java.util.NoSuchElementException;
import kodkod.util.ints.AbstractSparseSequence;
import kodkod.util.ints.IndexedEntry;
import kodkod.util.ints.IntTree;

public final class TreeSequence<V>
extends AbstractSparseSequence<V>
implements Cloneable {
    private final IntTree<Entry<V>> tree;
    private int size;

    public TreeSequence() {
        this.tree = new IntTree();
        this.size = 0;
    }

    private TreeSequence(TreeSequence<V> treeSequence) {
        this.size = treeSequence.size;
        try {
            this.tree = treeSequence.tree.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public Iterator<IndexedEntry<V>> iterator(int n, int n2) {
        return n <= n2 ? new AscendingIterator(n, n2) : new DescendingIterator(n, n2);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.tree.clear();
        this.size = 0;
    }

    @Override
    public V put(int n, V v) {
        Entry<V> entry = this.tree.search(n);
        if (entry == null) {
            ++this.size;
            this.tree.insert(new Entry<V>(n, v));
            return null;
        }
        return entry.setValue(v);
    }

    @Override
    public V get(int n) {
        Entry<V> entry = this.tree.search(n);
        return entry == null ? null : (V)entry.value;
    }

    @Override
    public V remove(int n) {
        Entry<V> entry = this.tree.search(n);
        if (entry == null) {
            return null;
        }
        --this.size;
        this.tree.delete(entry);
        return entry.value;
    }

    @Override
    public boolean containsIndex(int n) {
        return this.tree.search(n) != null;
    }

    @Override
    public IndexedEntry<V> first() {
        return this.tree.min();
    }

    @Override
    public IndexedEntry<V> last() {
        return this.tree.max();
    }

    @Override
    public IndexedEntry<V> ceil(int n) {
        return this.tree.searchGTE(n);
    }

    @Override
    public IndexedEntry<V> floor(int n) {
        return this.tree.searchLTE(n);
    }

    @Override
    public TreeSequence<V> clone() {
        return new TreeSequence<V>(this);
    }

    private final class DescendingIterator
    extends EntryIterator {
        DescendingIterator(int n, int n2) {
            super((Entry)TreeSequence.this.tree.searchLTE(n), n2);
        }

        @Override
        final void advance() {
            this.next = TreeSequence.this.tree.predecessor(this.next);
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.key >= this.endIndex;
        }
    }

    private final class AscendingIterator
    extends EntryIterator {
        AscendingIterator(int n, int n2) {
            super((Entry)TreeSequence.this.tree.searchGTE(n), n2);
        }

        @Override
        final void advance() {
            this.next = TreeSequence.this.tree.successor(this.next);
        }

        @Override
        public boolean hasNext() {
            return this.next != null && this.next.key <= this.endIndex;
        }
    }

    private abstract class EntryIterator
    implements Iterator<IndexedEntry<V>> {
        final int endIndex;
        Entry<V> lastReturned;
        Entry<V> next;

        EntryIterator(Entry<V> entry, int n) {
            this.next = entry;
            this.lastReturned = null;
            this.endIndex = n;
        }

        abstract void advance();

        @Override
        public abstract boolean hasNext();

        @Override
        public IndexedEntry<V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public final void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (this.next == null) {
                TreeSequence.this.remove(this.lastReturned.key);
            } else {
                int n = this.next.key;
                TreeSequence.this.remove(this.lastReturned.key);
                this.next = (Entry)TreeSequence.this.tree.search(n);
            }
            this.lastReturned = null;
        }
    }

    private static final class Entry<V>
    extends IntTree.Node<Entry<V>>
    implements IndexedEntry<V>,
    Cloneable {
        V value;

        Entry(int n, V v) {
            super(n);
            this.value = v;
        }

        @Override
        public int index() {
            return this.key;
        }

        @Override
        public V value() {
            return this.value;
        }

        V setValue(V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof IndexedEntry)) {
                return false;
            }
            return AbstractSparseSequence.equal(this, (IndexedEntry)object);
        }

        @Override
        public int hashCode() {
            return AbstractSparseSequence.hashCode(this);
        }

        @Override
        public String toString() {
            return this.key + "=" + this.value;
        }

        @Override
        protected Entry<V> clone() throws CloneNotSupportedException {
            return (Entry)super.clone();
        }
    }
}

