/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.nodes;

import java.util.Collections;
import java.util.EnumMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.BinaryFormula;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.Comprehension;
import kodkod.ast.ConstantExpression;
import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.ExprToIntCast;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IfExpression;
import kodkod.ast.IfIntExpression;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.IntToExprCast;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryFormula;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.Relation;
import kodkod.ast.RelationPredicate;
import kodkod.ast.SumExpression;
import kodkod.ast.Variable;
import kodkod.ast.operator.ExprCastOperator;
import kodkod.ast.operator.FormulaOperator;
import kodkod.ast.visitor.AbstractDetector;
import kodkod.ast.visitor.AbstractVoidVisitor;
import kodkod.util.collections.ArrayStack;
import kodkod.util.collections.IdentityHashSet;
import kodkod.util.collections.Stack;
import kodkod.util.nodes.Nodes;

public final class AnnotatedNode<N extends Node> {
    private final N node;
    private final Set<Node> sharedNodes;
    private final Map<? extends Node, ? extends Node> source;

    private AnnotatedNode(N n) {
        this.node = n;
        SharingDetector sharingDetector = new SharingDetector();
        ((Node)n).accept(sharingDetector);
        this.sharedNodes = Collections.unmodifiableSet(sharingDetector.sharedNodes());
        this.source = Collections.emptyMap();
    }

    private AnnotatedNode(N n, Map<? extends Node, ? extends Node> map) {
        this.node = n;
        SharingDetector sharingDetector = new SharingDetector();
        ((Node)n).accept(sharingDetector);
        this.sharedNodes = Collections.unmodifiableSet(sharingDetector.sharedNodes());
        this.source = map;
    }

    public static <N extends Node> AnnotatedNode<N> annotate(N n) {
        return new AnnotatedNode<N>(n);
    }

    public static <N extends Node> AnnotatedNode<N> annotate(N n, Map<? extends Node, ? extends Node> map) {
        return new AnnotatedNode<N>(n, map);
    }

    public static AnnotatedNode<Formula> annotateRoots(Formula formula) {
        Formula formula2 = Formula.and(Nodes.roots(formula));
        return new AnnotatedNode<Formula>(formula2, Collections.singletonMap(formula2, formula));
    }

    public final N node() {
        return this.node;
    }

    public final Node sourceOf(Node node) {
        Node node2 = this.source.get(node);
        return node2 == null ? node : node2;
    }

    public final Set<Node> sharedNodes() {
        return this.sharedNodes;
    }

    public final Set<Relation> relations() {
        final IdentityHashSet<Relation> identityHashSet = new IdentityHashSet<Relation>();
        AbstractVoidVisitor abstractVoidVisitor = new AbstractVoidVisitor(){
            private final Set<Node> visited;
            {
                this.visited = new IdentityHashSet<Node>(AnnotatedNode.this.sharedNodes.size());
            }

            @Override
            protected boolean visited(Node node) {
                return AnnotatedNode.this.sharedNodes.contains(node) && !this.visited.add(node);
            }

            @Override
            public void visit(Relation relation) {
                identityHashSet.add(relation);
            }
        };
        ((Node)this.node).accept(abstractVoidVisitor);
        return identityHashSet;
    }

    public final boolean usesInts() {
        AbstractDetector abstractDetector = new AbstractDetector(this.sharedNodes){

            @Override
            public Boolean visit(IntToExprCast intToExprCast) {
                return this.cache(intToExprCast, Boolean.TRUE);
            }

            @Override
            public Boolean visit(ExprToIntCast exprToIntCast) {
                if (exprToIntCast.op() == ExprCastOperator.CARDINALITY) {
                    super.visit(exprToIntCast);
                }
                return this.cache(exprToIntCast, Boolean.TRUE);
            }

            @Override
            public Boolean visit(ConstantExpression constantExpression) {
                return constantExpression == Expression.INTS ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        return (Boolean)((Node)this.node).accept(abstractDetector);
    }

    public final Map<RelationPredicate.Name, Set<RelationPredicate>> predicates() {
        PredicateCollector predicateCollector = new PredicateCollector(this.sharedNodes);
        ((Node)this.node).accept(predicateCollector);
        return predicateCollector.preds;
    }

    public final AbstractDetector quantifiedFormulaDetector() {
        return new AbstractDetector(this.sharedNodes){

            @Override
            public Boolean visit(QuantifiedFormula quantifiedFormula) {
                return this.cache(quantifiedFormula, true);
            }
        };
    }

    public final AbstractDetector freeVariableDetector() {
        return new FreeVariableDetector(this.sharedNodes);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("node: ");
        stringBuilder.append(this.node);
        stringBuilder.append("\nshared nodes: ");
        stringBuilder.append(this.sharedNodes);
        stringBuilder.append("\nsources: ");
        stringBuilder.append(this.source);
        return stringBuilder.toString();
    }

    private static final class PredicateCollector
    extends AbstractVoidVisitor {
        protected boolean negated;
        private final Set<Node> sharedNodes;
        private final Map<Node, Boolean> visited;
        final EnumMap<RelationPredicate.Name, Set<RelationPredicate>> preds;

        PredicateCollector(Set<Node> set) {
            this.sharedNodes = set;
            this.visited = new IdentityHashMap<Node, Boolean>();
            this.negated = false;
            this.preds = new EnumMap(RelationPredicate.Name.class);
            this.preds.put(RelationPredicate.Name.ACYCLIC, new IdentityHashSet(4));
            this.preds.put(RelationPredicate.Name.TOTAL_ORDERING, new IdentityHashSet(4));
            this.preds.put(RelationPredicate.Name.FUNCTION, new IdentityHashSet(8));
        }

        @Override
        protected final boolean visited(Node node) {
            if (this.sharedNodes.contains(node)) {
                if (!this.visited.containsKey(node)) {
                    this.visited.put(node, this.negated);
                    return false;
                }
                Boolean bl = this.visited.get(node);
                if (bl == null || bl == this.negated) {
                    return true;
                }
                this.visited.put(node, null);
                return false;
            }
            return false;
        }

        @Override
        public void visit(Comprehension comprehension) {
            this.visited(comprehension);
        }

        @Override
        public void visit(IfExpression ifExpression) {
            this.visited(ifExpression);
        }

        @Override
        public void visit(IfIntExpression ifIntExpression) {
            this.visited(ifIntExpression);
        }

        @Override
        public void visit(IntComparisonFormula intComparisonFormula) {
            this.visited(intComparisonFormula);
        }

        @Override
        public void visit(QuantifiedFormula quantifiedFormula) {
            this.visited(quantifiedFormula);
        }

        @Override
        public void visit(BinaryFormula binaryFormula) {
            if (this.visited(binaryFormula)) {
                return;
            }
            FormulaOperator formulaOperator = binaryFormula.op();
            if (!this.negated && formulaOperator == FormulaOperator.AND || this.negated && formulaOperator == FormulaOperator.OR) {
                binaryFormula.left().accept(this);
                binaryFormula.right().accept(this);
            } else if (this.negated && formulaOperator == FormulaOperator.IMPLIES) {
                this.negated = !this.negated;
                binaryFormula.left().accept(this);
                this.negated = !this.negated;
                binaryFormula.right().accept(this);
            }
        }

        @Override
        public void visit(NaryFormula naryFormula) {
            if (this.visited(naryFormula)) {
                return;
            }
            FormulaOperator formulaOperator = naryFormula.op();
            if (!this.negated && formulaOperator == FormulaOperator.AND || this.negated && formulaOperator == FormulaOperator.OR) {
                for (Formula formula : naryFormula) {
                    formula.accept(this);
                }
            }
        }

        @Override
        public void visit(NotFormula notFormula) {
            if (this.visited(notFormula)) {
                return;
            }
            this.negated = !this.negated;
            notFormula.formula().accept(this);
            this.negated = !this.negated;
        }

        @Override
        public void visit(ComparisonFormula comparisonFormula) {
            this.visited(comparisonFormula);
        }

        @Override
        public void visit(MultiplicityFormula multiplicityFormula) {
            this.visited(multiplicityFormula);
        }

        @Override
        public void visit(RelationPredicate relationPredicate) {
            if (this.visited(relationPredicate)) {
                return;
            }
            if (!this.negated) {
                this.preds.get((Object)relationPredicate.name()).add(relationPredicate);
            }
        }
    }

    private static final class FreeVariableDetector
    extends AbstractDetector {
        private final Stack<Variable> varsInScope = new ArrayStack<Variable>();

        FreeVariableDetector(Set<Node> set) {
            super(set);
        }

        private Boolean visit(Node node, Decls decls, Node node2) {
            Boolean bl = this.lookup(node);
            if (bl != null) {
                return bl;
            }
            boolean bl2 = false;
            for (Decl decl : decls) {
                bl2 = decl.expression().accept(this) != false || bl2;
                this.varsInScope.push(decl.variable());
            }
            bl2 = (Boolean)node2.accept(this) != false || bl2;
            for (int i = decls.size(); i > 0; --i) {
                this.varsInScope.pop();
            }
            return this.cache(node, bl2);
        }

        @Override
        public Boolean visit(Variable variable) {
            return this.varsInScope.search(variable) < 0;
        }

        @Override
        public Boolean visit(Decl decl) {
            Boolean bl = this.lookup(decl);
            if (bl != null) {
                return bl;
            }
            return this.cache(decl, decl.expression().accept(this));
        }

        @Override
        public Boolean visit(Comprehension comprehension) {
            return this.visit(comprehension, comprehension.decls(), comprehension.formula());
        }

        @Override
        public Boolean visit(SumExpression sumExpression) {
            return this.visit(sumExpression, sumExpression.decls(), sumExpression.intExpr());
        }

        @Override
        public Boolean visit(QuantifiedFormula quantifiedFormula) {
            return this.visit(quantifiedFormula, quantifiedFormula.decls(), quantifiedFormula.formula());
        }
    }

    private static final class SharingDetector
    extends AbstractVoidVisitor {
        final IdentityHashMap<Node, Boolean> sharingStatus = new IdentityHashMap();
        int numSharedNodes;

        SharingDetector() {
        }

        IdentityHashSet<Node> sharedNodes() {
            IdentityHashSet<Node> identityHashSet = new IdentityHashSet<Node>(this.numSharedNodes);
            for (Map.Entry<Node, Boolean> entry : this.sharingStatus.entrySet()) {
                if (entry.getValue() != Boolean.TRUE) continue;
                identityHashSet.add(entry.getKey());
            }
            return identityHashSet;
        }

        @Override
        protected final boolean visited(Node node) {
            Boolean bl = this.sharingStatus.get(node);
            if (!Boolean.TRUE.equals(bl)) {
                if (bl == null) {
                    bl = Boolean.FALSE;
                } else {
                    bl = Boolean.TRUE;
                    ++this.numSharedNodes;
                }
                this.sharingStatus.put(node, bl);
            }
            return bl;
        }
    }
}

