/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.nodes;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Set;
import kodkod.ast.BinaryFormula;
import kodkod.ast.Formula;
import kodkod.ast.NaryFormula;
import kodkod.ast.Node;
import kodkod.ast.operator.FormulaOperator;
import kodkod.ast.visitor.AbstractDetector;
import kodkod.ast.visitor.AbstractVoidVisitor;
import kodkod.util.collections.Containers;
import kodkod.util.collections.IdentityHashSet;

public final class Nodes {
    private Nodes() {
    }

    public static Set<Formula> roots(Formula formula) {
        LinkedList<Formula> linkedList = new LinkedList<Formula>();
        linkedList.add(formula);
        ListIterator<Formula> listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            Formula formula2;
            Formula formula3 = (Formula)listIterator.next();
            if (formula3 instanceof BinaryFormula) {
                formula2 = (BinaryFormula)formula3;
                if (((BinaryFormula)formula2).op() != FormulaOperator.AND) continue;
                listIterator.remove();
                listIterator.add(((BinaryFormula)formula2).left());
                listIterator.add(((BinaryFormula)formula2).right());
                listIterator.previous();
                listIterator.previous();
                continue;
            }
            if (!(formula3 instanceof NaryFormula) || ((NaryFormula)(formula2 = (NaryFormula)formula3)).op() != FormulaOperator.AND) continue;
            listIterator.remove();
            Iterator<Formula> iterator = ((NaryFormula)formula2).iterator();
            while (iterator.hasNext()) {
                Formula formula4 = iterator.next();
                listIterator.add(formula4);
            }
            for (int i = ((NaryFormula)formula2).size(); i > 0; --i) {
                listIterator.previous();
            }
        }
        return new LinkedHashSet<Formula>(linkedList);
    }

    public static Set<Formula> conjuncts(Formula formula) {
        NaryFormula naryFormula;
        if (formula instanceof BinaryFormula) {
            BinaryFormula binaryFormula = (BinaryFormula)formula;
            if (binaryFormula.op() == FormulaOperator.AND) {
                Formula formula2;
                final Formula formula3 = binaryFormula.left();
                if (formula3 == (formula2 = binaryFormula.right())) {
                    return Collections.singleton(formula3);
                }
                return new AbstractSet<Formula>(){

                    @Override
                    public boolean contains(Object object) {
                        return formula3 == object || formula2 == object;
                    }

                    @Override
                    public Iterator<Formula> iterator() {
                        return Containers.iterate(formula3, formula2);
                    }

                    @Override
                    public int size() {
                        return 2;
                    }
                };
            }
        } else if (formula instanceof NaryFormula && (naryFormula = (NaryFormula)formula).op() == FormulaOperator.AND) {
            LinkedHashSet<Formula> linkedHashSet = new LinkedHashSet<Formula>(1 + naryFormula.size() * 4 / 3);
            for (Formula formula4 : naryFormula) {
                linkedHashSet.add(formula4);
            }
            return Collections.unmodifiableSet(linkedHashSet);
        }
        return Collections.singleton(formula);
    }

    public static Set<Formula> minRoots(Formula formula, Collection<? extends Node> collection) {
        final IdentityHashSet<? extends Node> identityHashSet = new IdentityHashSet<Node>(collection);
        AbstractVoidVisitor abstractVoidVisitor = new AbstractVoidVisitor(){
            final Set<Node> visited = new IdentityHashSet<Node>();

            @Override
            protected boolean visited(Node node) {
                if (this.visited.add(node)) {
                    identityHashSet.remove(node);
                    return false;
                }
                return true;
            }
        };
        LinkedHashSet<Formula> linkedHashSet = new LinkedHashSet<Formula>();
        for (Formula formula2 : Nodes.roots(formula)) {
            int n = identityHashSet.size();
            formula2.accept(abstractVoidVisitor);
            if (identityHashSet.size() < n) {
                linkedHashSet.add(formula2);
            }
            if (!identityHashSet.isEmpty()) continue;
            break;
        }
        if (!identityHashSet.isEmpty()) {
            throw new IllegalArgumentException("descendants !in formula.*components: formula=" + formula + " ; descendants=" + collection);
        }
        return linkedHashSet;
    }

    public static Set<Formula> allRoots(Formula formula, Collection<? extends Node> collection) {
        final IdentityHashSet<? extends Node> identityHashSet = new IdentityHashSet<Node>(collection);
        AbstractDetector abstractDetector = new AbstractDetector(Collections.EMPTY_SET){

            @Override
            protected Boolean lookup(Node node) {
                return identityHashSet.contains(node) ? Boolean.TRUE : (Boolean)this.cache.get(node);
            }

            @Override
            protected Boolean cache(Node node, boolean bl) {
                Boolean bl2 = bl;
                this.cache.put(node, bl2);
                return bl2;
            }
        };
        LinkedHashSet<Formula> linkedHashSet = new LinkedHashSet<Formula>();
        for (Formula formula2 : Nodes.roots(formula)) {
            if (!formula2.accept(abstractDetector).booleanValue()) continue;
            linkedHashSet.add(formula2);
        }
        return linkedHashSet;
    }
}

