/*
 * Decompiled with CFR 0.152.
 */
package kodkod.util.nodes;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kodkod.ast.BinaryExpression;
import kodkod.ast.BinaryFormula;
import kodkod.ast.BinaryIntExpression;
import kodkod.ast.ComparisonFormula;
import kodkod.ast.Comprehension;
import kodkod.ast.ConstantExpression;
import kodkod.ast.ConstantFormula;
import kodkod.ast.Decl;
import kodkod.ast.Decls;
import kodkod.ast.ExprToIntCast;
import kodkod.ast.Expression;
import kodkod.ast.Formula;
import kodkod.ast.IfExpression;
import kodkod.ast.IfIntExpression;
import kodkod.ast.IntComparisonFormula;
import kodkod.ast.IntConstant;
import kodkod.ast.IntExpression;
import kodkod.ast.IntToExprCast;
import kodkod.ast.LeafExpression;
import kodkod.ast.MultiplicityFormula;
import kodkod.ast.NaryExpression;
import kodkod.ast.NaryFormula;
import kodkod.ast.NaryIntExpression;
import kodkod.ast.Node;
import kodkod.ast.NotFormula;
import kodkod.ast.ProjectExpression;
import kodkod.ast.QuantifiedFormula;
import kodkod.ast.Relation;
import kodkod.ast.RelationPredicate;
import kodkod.ast.SumExpression;
import kodkod.ast.UnaryExpression;
import kodkod.ast.UnaryIntExpression;
import kodkod.ast.Variable;
import kodkod.ast.operator.ExprOperator;
import kodkod.ast.operator.FormulaOperator;
import kodkod.ast.operator.IntOperator;
import kodkod.ast.operator.Multiplicity;
import kodkod.ast.visitor.VoidVisitor;

public final class PrettyPrinter {
    public static String dotify(Node node) {
        return Dotifier.apply(node);
    }

    public static String print(Node node, int n, int n2) {
        Formatter formatter = new Formatter(n, n2);
        node.accept(formatter);
        return formatter.tokens.toString();
    }

    public static String print(Node node, int n) {
        return PrettyPrinter.print(node, n, 80);
    }

    public static String print(Set<Formula> set, int n) {
        return PrettyPrinter.print(set, n, 80);
    }

    public static String print(Set<Formula> set, int n, int n2) {
        Formatter formatter = new Formatter(n, n2);
        for (Formula formula : set) {
            formula.accept(formatter);
            formatter.newline();
        }
        return formatter.tokens.toString();
    }

    private static class Dotifier
    implements VoidVisitor {
        private final StringBuilder graph = new StringBuilder();
        private final Map<Node, Integer> ids = new LinkedHashMap<Node, Integer>();

        private Dotifier() {
        }

        static String apply(Node node) {
            Dotifier dotifier = new Dotifier();
            dotifier.graph.append("digraph {\n");
            node.accept(dotifier);
            dotifier.graph.append("}");
            return dotifier.graph.toString();
        }

        private boolean visited(Node node) {
            if (this.ids.containsKey(node)) {
                return true;
            }
            this.ids.put(node, this.ids.size());
            return false;
        }

        private String id(Node node) {
            return "N" + this.ids.get(node);
        }

        private void node(Node node, String string) {
            this.graph.append(this.id(node));
            this.graph.append("[ label=\"");
            this.graph.append(this.ids.get(node));
            this.graph.append("(");
            this.graph.append(string);
            this.graph.append(")\"];\n");
        }

        private void edge(Node node, Node node2) {
            if (node2 instanceof LeafExpression || node2 instanceof ConstantFormula || node2 instanceof IntConstant) {
                // empty if block
            }
            this.graph.append(this.id(node));
            this.graph.append("->");
            this.graph.append(this.id(node2));
            this.graph.append(";\n");
        }

        private void visit(Node node, Object object) {
            if (this.visited(node)) {
                return;
            }
            this.node(node, object.toString());
        }

        private void visit(Node node, Object object, Node node2) {
            if (this.visited(node)) {
                return;
            }
            this.node(node, object.toString());
            node2.accept(this);
            this.edge(node, node2);
        }

        private void visit(Node node, Object object, Node node2, Node node3) {
            if (this.visited(node)) {
                return;
            }
            this.node(node, object.toString());
            node2.accept(this);
            node3.accept(this);
            this.edge(node, node2);
            this.edge(node, node3);
        }

        private void visit(Node node, Object object, Node node2, Node node3, Node node4) {
            if (this.visited(node)) {
                return;
            }
            this.node(node, object.toString());
            node2.accept(this);
            node3.accept(this);
            node4.accept(this);
            this.edge(node, node2);
            this.edge(node, node3);
            this.edge(node, node4);
        }

        private void visit(Node node, Object object, Iterator<? extends Node> iterator) {
            if (this.visited(node)) {
                return;
            }
            this.node(node, object.toString());
            while (iterator.hasNext()) {
                Node node2 = iterator.next();
                node2.accept(this);
                this.edge(node, node2);
            }
        }

        private void visit(Node node, Object object, Node node2, Iterator<? extends Node> iterator) {
            if (this.visited(node)) {
                return;
            }
            this.node(node, object.toString());
            node2.accept(this);
            this.edge(node, node2);
            while (iterator.hasNext()) {
                Node node3 = iterator.next();
                node3.accept(this);
                this.edge(node, node3);
            }
        }

        @Override
        public void visit(Decls decls) {
            this.visit((Node)decls, (Object)"decls", decls.iterator());
        }

        @Override
        public void visit(Decl decl) {
            this.visit((Node)decl, (Object)"decl", (Node)decl.variable(), decl.expression());
        }

        @Override
        public void visit(Relation relation) {
            this.visit(relation, relation.name());
        }

        @Override
        public void visit(Variable variable) {
            this.visit(variable, variable.name());
        }

        @Override
        public void visit(ConstantExpression constantExpression) {
            this.visit(constantExpression, constantExpression.name());
        }

        @Override
        public void visit(NaryExpression naryExpression) {
            this.visit((Node)naryExpression, (Object)naryExpression.op(), naryExpression.iterator());
        }

        @Override
        public void visit(BinaryExpression binaryExpression) {
            this.visit((Node)binaryExpression, (Object)binaryExpression.op(), (Node)binaryExpression.left(), binaryExpression.right());
        }

        @Override
        public void visit(UnaryExpression unaryExpression) {
            this.visit((Node)unaryExpression, (Object)unaryExpression.op(), unaryExpression.expression());
        }

        @Override
        public void visit(Comprehension comprehension) {
            this.visit((Node)comprehension, (Object)"setcomp", (Node)comprehension.decls(), comprehension.formula());
        }

        @Override
        public void visit(IfExpression ifExpression) {
            this.visit(ifExpression, "ite", ifExpression.condition(), ifExpression.thenExpr(), ifExpression.elseExpr());
        }

        @Override
        public void visit(ProjectExpression projectExpression) {
            this.visit((Node)projectExpression, (Object)"proj", (Node)projectExpression.expression(), projectExpression.columns());
        }

        @Override
        public void visit(IntToExprCast intToExprCast) {
            this.visit((Node)intToExprCast, (Object)intToExprCast.op(), intToExprCast.intExpr());
        }

        @Override
        public void visit(IntConstant intConstant) {
            this.visit(intConstant, intConstant.value());
        }

        @Override
        public void visit(IfIntExpression ifIntExpression) {
            this.visit(ifIntExpression, "ite", ifIntExpression.condition(), ifIntExpression.thenExpr(), ifIntExpression.elseExpr());
        }

        @Override
        public void visit(ExprToIntCast exprToIntCast) {
            this.visit((Node)exprToIntCast, (Object)exprToIntCast.op(), exprToIntCast.expression());
        }

        @Override
        public void visit(NaryIntExpression naryIntExpression) {
            this.visit((Node)naryIntExpression, (Object)naryIntExpression.op(), naryIntExpression.iterator());
        }

        @Override
        public void visit(BinaryIntExpression binaryIntExpression) {
            this.visit((Node)binaryIntExpression, (Object)binaryIntExpression.op(), (Node)binaryIntExpression.left(), binaryIntExpression.right());
        }

        @Override
        public void visit(UnaryIntExpression unaryIntExpression) {
            this.visit((Node)unaryIntExpression, (Object)unaryIntExpression.op(), unaryIntExpression.intExpr());
        }

        @Override
        public void visit(SumExpression sumExpression) {
            this.visit((Node)sumExpression, (Object)"sum", (Node)sumExpression.decls(), sumExpression.intExpr());
        }

        @Override
        public void visit(IntComparisonFormula intComparisonFormula) {
            this.visit((Node)intComparisonFormula, (Object)intComparisonFormula.op(), (Node)intComparisonFormula.left(), intComparisonFormula.right());
        }

        @Override
        public void visit(QuantifiedFormula quantifiedFormula) {
            this.visit((Node)quantifiedFormula, (Object)quantifiedFormula.quantifier(), (Node)quantifiedFormula.decls(), quantifiedFormula.formula());
        }

        @Override
        public void visit(NaryFormula naryFormula) {
            this.visit((Node)naryFormula, (Object)naryFormula.op(), naryFormula.iterator());
        }

        @Override
        public void visit(BinaryFormula binaryFormula) {
            this.visit((Node)binaryFormula, (Object)binaryFormula.op(), (Node)binaryFormula.left(), binaryFormula.right());
        }

        @Override
        public void visit(NotFormula notFormula) {
            this.visit((Node)notFormula, (Object)"not", notFormula.formula());
        }

        @Override
        public void visit(ConstantFormula constantFormula) {
            this.visit(constantFormula, constantFormula.booleanValue());
        }

        @Override
        public void visit(ComparisonFormula comparisonFormula) {
            this.visit((Node)comparisonFormula, (Object)comparisonFormula.op(), (Node)comparisonFormula.left(), comparisonFormula.right());
        }

        @Override
        public void visit(MultiplicityFormula multiplicityFormula) {
            this.visit((Node)multiplicityFormula, (Object)multiplicityFormula.multiplicity(), multiplicityFormula.expression());
        }

        @Override
        public void visit(RelationPredicate relationPredicate) {
            if (this.visited(relationPredicate)) {
                return;
            }
            if (relationPredicate.name() == RelationPredicate.Name.FUNCTION) {
                RelationPredicate.Function function = (RelationPredicate.Function)relationPredicate;
                this.visit((Node)function, (Object)function.name(), (Node)function.domain(), function.range());
            } else if (relationPredicate.name() == RelationPredicate.Name.TOTAL_ORDERING) {
                RelationPredicate.TotalOrdering totalOrdering = (RelationPredicate.TotalOrdering)relationPredicate;
                this.visit(totalOrdering, (Object)totalOrdering.name(), totalOrdering.ordered(), totalOrdering.first(), totalOrdering.last());
            } else {
                throw new IllegalArgumentException("Unknown predicate: " + relationPredicate);
            }
        }
    }

    private static class Formatter
    implements VoidVisitor {
        final StringBuilder tokens;
        private final int lineLength;
        private int indent;
        private int lineStart;

        Formatter(int n, int n2) {
            assert (n >= 0 && n < n2);
            this.tokens = new StringBuilder();
            this.lineLength = n2;
            this.lineStart = 0;
            this.indent = n;
            this.indent();
        }

        private void infix(Object object) {
            this.space();
            this.tokens.append(object);
            this.space();
        }

        private void keyword(Object object) {
            this.append(object);
            this.space();
        }

        private void comma() {
            this.tokens.append(",");
            this.space();
        }

        private void colon() {
            this.tokens.append(":");
            this.space();
        }

        private void indent() {
            for (int i = 0; i < this.indent; ++i) {
                this.space();
            }
        }

        private void newline() {
            this.tokens.append("\n");
            this.lineStart = this.tokens.length();
            this.indent();
        }

        private void space() {
            this.tokens.append(" ");
        }

        private void append(Object object) {
            String string = String.valueOf(object);
            if (this.tokens.length() - this.lineStart + string.length() > this.lineLength) {
                this.newline();
            }
            this.tokens.append(string);
        }

        @Override
        public void visit(Relation relation) {
            this.append(relation);
        }

        @Override
        public void visit(Variable variable) {
            this.append(variable);
        }

        @Override
        public void visit(ConstantExpression constantExpression) {
            this.append(constantExpression);
        }

        @Override
        public void visit(IntConstant intConstant) {
            this.append(intConstant);
        }

        @Override
        public void visit(ConstantFormula constantFormula) {
            this.append(constantFormula);
        }

        @Override
        public void visit(Decl decl) {
            decl.variable().accept(this);
            this.colon();
            if (decl.multiplicity() != Multiplicity.ONE) {
                this.append((Object)decl.multiplicity());
                this.space();
            }
            decl.expression().accept(this);
        }

        @Override
        public void visit(Decls decls) {
            Iterator<Decl> iterator = decls.iterator();
            iterator.next().accept(this);
            while (iterator.hasNext()) {
                this.comma();
                iterator.next().accept(this);
            }
        }

        private void visitChild(Node node, boolean bl) {
            if (bl) {
                this.append("(");
            }
            node.accept(this);
            if (bl) {
                this.append(")");
            }
        }

        private boolean parenthesize(Expression expression) {
            return expression instanceof BinaryExpression || expression instanceof IfExpression;
        }

        private boolean parenthesize(IntExpression intExpression) {
            return !(intExpression instanceof UnaryIntExpression) && !(intExpression instanceof IntConstant) && !(intExpression instanceof ExprToIntCast);
        }

        private boolean parenthesize(Formula formula) {
            return !(formula instanceof NotFormula) && !(formula instanceof ConstantFormula) && !(formula instanceof RelationPredicate);
        }

        @Override
        public void visit(UnaryExpression unaryExpression) {
            this.append((Object)unaryExpression.op());
            this.visitChild(unaryExpression.expression(), this.parenthesize(unaryExpression.expression()));
        }

        @Override
        public void visit(UnaryIntExpression unaryIntExpression) {
            IntExpression intExpression = unaryIntExpression.intExpr();
            IntOperator intOperator = unaryIntExpression.op();
            boolean bl = intOperator == IntOperator.ABS || intOperator == IntOperator.SGN || this.parenthesize(intExpression);
            this.append((Object)unaryIntExpression.op());
            this.visitChild(intExpression, bl);
        }

        @Override
        public void visit(NotFormula notFormula) {
            this.append("!");
            boolean bl = this.parenthesize(notFormula.formula());
            this.indent += bl ? 2 : 1;
            this.visitChild(notFormula.formula(), this.parenthesize(notFormula.formula()));
            this.indent -= bl ? 2 : 1;
        }

        @Override
        public void visit(MultiplicityFormula multiplicityFormula) {
            this.keyword((Object)multiplicityFormula.multiplicity());
            this.visitChild(multiplicityFormula.expression(), this.parenthesize(multiplicityFormula.expression()));
        }

        private boolean parenthesize(ExprOperator exprOperator, Expression expression) {
            return expression instanceof IfExpression || expression instanceof NaryExpression || expression instanceof BinaryExpression && (exprOperator == ExprOperator.JOIN || ((BinaryExpression)expression).op() != exprOperator);
        }

        @Override
        public void visit(BinaryExpression binaryExpression) {
            ExprOperator exprOperator = binaryExpression.op();
            this.visitChild(binaryExpression.left(), this.parenthesize(exprOperator, binaryExpression.left()));
            this.infix((Object)exprOperator);
            this.visitChild(binaryExpression.right(), this.parenthesize(exprOperator, binaryExpression.right()));
        }

        private boolean associative(IntOperator intOperator) {
            switch (intOperator) {
                case DIVIDE: 
                case MODULO: 
                case SHA: 
                case SHL: 
                case SHR: {
                    return false;
                }
            }
            return true;
        }

        private boolean parenthesize(IntOperator intOperator, IntExpression intExpression) {
            return intExpression instanceof SumExpression || intExpression instanceof IfIntExpression || intExpression instanceof NaryIntExpression || intExpression instanceof BinaryIntExpression && (!this.associative(intOperator) || ((BinaryIntExpression)intExpression).op() != intOperator);
        }

        @Override
        public void visit(BinaryIntExpression binaryIntExpression) {
            IntOperator intOperator = binaryIntExpression.op();
            this.visitChild(binaryIntExpression.left(), this.parenthesize(intOperator, binaryIntExpression.left()));
            this.infix((Object)intOperator);
            this.visitChild(binaryIntExpression.right(), this.parenthesize(intOperator, binaryIntExpression.right()));
        }

        private boolean parenthesize(FormulaOperator formulaOperator, Formula formula) {
            return formula instanceof QuantifiedFormula || formula instanceof BinaryFormula && (formulaOperator == FormulaOperator.IMPLIES || ((BinaryFormula)formula).op() != formulaOperator);
        }

        @Override
        public void visit(BinaryFormula binaryFormula) {
            FormulaOperator formulaOperator = binaryFormula.op();
            boolean bl = this.parenthesize(formulaOperator, binaryFormula.left());
            if (bl) {
                ++this.indent;
            }
            this.visitChild(binaryFormula.left(), bl);
            if (bl) {
                --this.indent;
            }
            this.infix((Object)formulaOperator);
            this.newline();
            boolean bl2 = this.parenthesize(formulaOperator, binaryFormula.right());
            if (bl2) {
                ++this.indent;
            }
            this.visitChild(binaryFormula.right(), bl2);
            if (bl2) {
                --this.indent;
            }
        }

        @Override
        public void visit(ComparisonFormula comparisonFormula) {
            this.visitChild(comparisonFormula.left(), this.parenthesize(comparisonFormula.left()));
            this.infix((Object)comparisonFormula.op());
            this.visitChild(comparisonFormula.right(), this.parenthesize(comparisonFormula.right()));
        }

        @Override
        public void visit(IntComparisonFormula intComparisonFormula) {
            this.visitChild(intComparisonFormula.left(), this.parenthesize(intComparisonFormula.left()));
            this.infix((Object)intComparisonFormula.op());
            this.visitChild(intComparisonFormula.right(), this.parenthesize(intComparisonFormula.right()));
        }

        @Override
        public void visit(IfExpression ifExpression) {
            this.visitChild(ifExpression.condition(), this.parenthesize(ifExpression.condition()));
            this.infix("=>");
            ++this.indent;
            this.newline();
            this.visitChild(ifExpression.thenExpr(), this.parenthesize(ifExpression.thenExpr()));
            this.infix("else");
            this.newline();
            this.visitChild(ifExpression.elseExpr(), this.parenthesize(ifExpression.elseExpr()));
            --this.indent;
        }

        @Override
        public void visit(IfIntExpression ifIntExpression) {
            this.visitChild(ifIntExpression.condition(), this.parenthesize(ifIntExpression.condition()));
            this.infix("=>");
            ++this.indent;
            this.newline();
            this.visitChild(ifIntExpression.thenExpr(), this.parenthesize(ifIntExpression.thenExpr()));
            this.infix("else");
            this.newline();
            this.visitChild(ifIntExpression.elseExpr(), this.parenthesize(ifIntExpression.elseExpr()));
            --this.indent;
        }

        @Override
        public void visit(Comprehension comprehension) {
            this.append("{");
            comprehension.decls().accept(this);
            this.infix("|");
            comprehension.formula().accept(this);
            this.append("}");
        }

        @Override
        public void visit(SumExpression sumExpression) {
            this.keyword("sum");
            sumExpression.decls().accept(this);
            this.infix("|");
            sumExpression.intExpr().accept(this);
        }

        @Override
        public void visit(QuantifiedFormula quantifiedFormula) {
            this.keyword((Object)quantifiedFormula.quantifier());
            quantifiedFormula.decls().accept(this);
            this.infix("|");
            ++this.indent;
            this.newline();
            quantifiedFormula.formula().accept(this);
            --this.indent;
        }

        @Override
        public void visit(NaryExpression naryExpression) {
            ExprOperator exprOperator = naryExpression.op();
            this.visitChild(naryExpression.child(0), this.parenthesize(exprOperator, naryExpression.child(0)));
            int n = naryExpression.size();
            for (int i = 1; i < n; ++i) {
                this.infix((Object)exprOperator);
                this.visitChild(naryExpression.child(i), this.parenthesize(exprOperator, naryExpression.child(i)));
            }
        }

        @Override
        public void visit(NaryIntExpression naryIntExpression) {
            IntOperator intOperator = naryIntExpression.op();
            this.visitChild(naryIntExpression.child(0), this.parenthesize(intOperator, naryIntExpression.child(0)));
            int n = naryIntExpression.size();
            for (int i = 1; i < n; ++i) {
                this.infix((Object)intOperator);
                this.visitChild(naryIntExpression.child(i), this.parenthesize(intOperator, naryIntExpression.child(i)));
            }
        }

        @Override
        public void visit(NaryFormula naryFormula) {
            FormulaOperator formulaOperator = naryFormula.op();
            boolean bl = this.parenthesize(formulaOperator, naryFormula.child(0));
            if (bl) {
                ++this.indent;
            }
            this.visitChild(naryFormula.child(0), bl);
            if (bl) {
                --this.indent;
            }
            int n = naryFormula.size();
            for (int i = 1; i < n; ++i) {
                this.infix((Object)formulaOperator);
                this.newline();
                bl = this.parenthesize(formulaOperator, naryFormula.child(i));
                if (bl) {
                    ++this.indent;
                }
                this.visitChild(naryFormula.child(i), bl);
                if (!bl) continue;
                --this.indent;
            }
        }

        @Override
        public void visit(ProjectExpression projectExpression) {
            this.append("project");
            this.append("[");
            projectExpression.expression().accept(this);
            this.comma();
            this.append("<");
            Iterator<IntExpression> iterator = projectExpression.columns();
            iterator.next().accept(this);
            while (iterator.hasNext()) {
                this.comma();
                iterator.next().accept(this);
            }
            this.append(">");
            this.append("]");
        }

        @Override
        public void visit(IntToExprCast intToExprCast) {
            this.append("Int");
            this.append("[");
            intToExprCast.intExpr().accept(this);
            this.append("]");
        }

        @Override
        public void visit(ExprToIntCast exprToIntCast) {
            switch (exprToIntCast.op()) {
                case SUM: {
                    this.append("int");
                    this.append("[");
                    exprToIntCast.expression().accept(this);
                    this.append("]");
                    break;
                }
                case CARDINALITY: {
                    this.append("#");
                    this.append("(");
                    exprToIntCast.expression().accept(this);
                    this.append(")");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("unknown operator: " + (Object)((Object)exprToIntCast.op()));
                }
            }
        }

        @Override
        public void visit(RelationPredicate relationPredicate) {
            switch (relationPredicate.name()) {
                case ACYCLIC: {
                    this.append("acyclic");
                    this.append("[");
                    relationPredicate.relation().accept(this);
                    this.append("]");
                    break;
                }
                case FUNCTION: {
                    RelationPredicate.Function function = (RelationPredicate.Function)relationPredicate;
                    this.append("function");
                    this.append("[");
                    function.relation().accept(this);
                    this.colon();
                    function.domain().accept(this);
                    this.infix("->");
                    this.keyword((Object)function.targetMult());
                    function.range().accept(this);
                    this.append("]");
                    break;
                }
                case TOTAL_ORDERING: {
                    RelationPredicate.TotalOrdering totalOrdering = (RelationPredicate.TotalOrdering)relationPredicate;
                    this.append("ord");
                    this.append("[");
                    totalOrdering.relation().accept(this);
                    this.comma();
                    totalOrdering.ordered().accept(this);
                    this.comma();
                    totalOrdering.first().accept(this);
                    this.comma();
                    totalOrdering.last().accept(this);
                    this.append("]");
                    break;
                }
                default: {
                    throw new AssertionError((Object)"unreachable");
                }
            }
        }
    }
}

