/*
 * Decompiled with CFR 0.152.
 */
package isabelle.kodkodi;

import java.util.Calendar;
import java.util.List;
import java.util.Set;
import kodkod.ast.Decl;
import kodkod.ast.Formula;
import kodkod.ast.Relation;
import kodkod.engine.bool.BooleanFormula;
import kodkod.engine.config.Reporter;
import kodkod.instance.Bounds;
import kodkod.util.ints.IntSet;

public class ConsoleReporterV2
implements Reporter {
    int problemNo = -1;
    boolean printsTimestamps = false;

    void output(String string) {
        System.out.println(string);
        System.out.flush();
    }

    private static String num2(int n) {
        char[] cArray = new char[]{(char)(n / 10 + 48), (char)(n % 10 + 48)};
        return new String(cArray);
    }

    private static String num3(int n) {
        char[] cArray = new char[]{(char)(n / 100 + 48), (char)(n / 10 % 10 + 48), (char)(n % 10 + 48)};
        return new String(cArray);
    }

    public void printlnWithTimestamp(String string) {
        Calendar calendar = Calendar.getInstance();
        this.output(ConsoleReporterV2.num2(calendar.get(11)) + ":" + ConsoleReporterV2.num2(calendar.get(12)) + ":" + ConsoleReporterV2.num2(calendar.get(13)) + "." + ConsoleReporterV2.num3(calendar.get(14)) + ": " + string);
    }

    public void setProblemNo(int n) {
        this.problemNo = n;
    }

    public int problemNo() {
        return this.problemNo;
    }

    public void setPrintsTimestamps(boolean bl) {
        this.printsTimestamps = true;
    }

    public boolean printsTimestamps() {
        return this.printsTimestamps;
    }

    public void println(String string) {
        String string2 = this.problemNo >= 0 ? "[" + this.problemNo + "] " + string : string;
        if (this.printsTimestamps) {
            this.printlnWithTimestamp(string2);
        } else {
            this.output(string2);
        }
    }

    public void generatingSBP() {
        this.println("generating lex-leader symmetry breaking predicate...");
    }

    public void flattening(BooleanFormula booleanFormula) {
        this.println("flattening...");
    }

    public void skolemizing(Decl decl, Relation relation, List<Decl> list) {
        this.println("skolemizing " + decl + ": skolem relation=" + relation + ", arity=" + relation.arity());
    }

    public void solvingCNF(int n, int n2, int n3) {
        this.println("solving p cnf " + n2 + " " + n3);
    }

    public void detectingSymmetries(Bounds bounds) {
        this.println("detecting symmetries...");
    }

    public void detectedSymmetries(Set<IntSet> set) {
        this.println("detected symmetries: " + set);
    }

    public void optimizingBoundsAndFormula() {
        this.println("optimizing bounds and formula (breaking predicate symmetries, inlining, skolemizing)...");
    }

    public void translatingToBoolean(Formula formula, Bounds bounds) {
        this.println("translating to boolean...");
    }

    public void translatingToCNF(BooleanFormula booleanFormula) {
        this.println("translating to cnf...");
    }

    public String toString() {
        return "ConsoleReporterV2";
    }
}

