/*
 * Decompiled with CFR 0.152.
 */
package isabelle.kodkodi;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.BitSet;
import kodkod.engine.satlab.SATAbortedException;
import kodkod.engine.satlab.SATFactory;
import kodkod.engine.satlab.SATSolver;

final class ExternalSolverV2
implements SATSolver {
    private final Charset UTF8 = Charset.forName("UTF-8");
    private final StringBuilder buffer = new StringBuilder(65536);
    private final String executable;
    private final boolean outTemp;
    private final String[] options;
    private final BitSet solution = new BitSet();
    private volatile Boolean sat = null;
    private volatile int vars = 0;
    private volatile int clauses = 0;
    private String satTag;
    private String solutionTag;
    private String unsatTag;

    ExternalSolverV2(String string, boolean bl, String string2, String string3, String string4, String ... stringArray) {
        this.executable = string;
        this.options = stringArray;
        this.outTemp = bl;
        this.satTag = string2;
        this.solutionTag = string3;
        this.unsatTag = string4;
    }

    public boolean addClause(int[] nArray) {
        if (nArray.length > 0) {
            ++this.clauses;
            for (int n : nArray) {
                this.buffer.append(n);
                this.buffer.append(" ");
            }
            this.buffer.append("0\n");
            return true;
        }
        return false;
    }

    public void addVariables(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("vars < 0: " + n);
        }
        this.vars += n;
    }

    public synchronized void free() {
    }

    public int numberOfClauses() {
        return this.clauses;
    }

    public int numberOfVariables() {
        return this.vars;
    }

    private final void updateSolution(int n) {
        int n2 = StrictMath.abs(n);
        if (n2 > this.vars || n2 <= 0) {
            throw new RuntimeException("invalid variable value: |" + n + "| !in [1.." + this.vars + "]");
        }
        this.solution.set(n2 - 1, n > 0);
    }

    public boolean solve() throws SATAbortedException {
        if (this.sat == null) {
            Path path = null;
            Path path2 = null;
            Process process = null;
            try {
                String string;
                BufferedReader bufferedReader;
                path = Files.createTempFile("tmp", "cnf", new FileAttribute[0]);
                path2 = this.outTemp ? Files.createTempFile("tmp", "out", new FileAttribute[0]) : null;
                BufferedWriter bufferedWriter = Files.newBufferedWriter(path, this.UTF8, new OpenOption[0]);
                bufferedWriter.write("p cnf " + this.vars + " " + this.clauses + "\n");
                bufferedWriter.write(this.buffer.toString());
                bufferedWriter.write("\n");
                bufferedWriter.close();
                this.buffer.setLength(0);
                int n = this.outTemp ? 3 : 2;
                String[] stringArray = new String[n + this.options.length];
                stringArray[0] = this.executable;
                stringArray[1] = path.toString();
                if (this.outTemp) {
                    stringArray[2] = path2.toString();
                }
                System.arraycopy(this.options, 0, stringArray, n, this.options.length);
                process = Runtime.getRuntime().exec(stringArray);
                new Thread(new Drainer(process.getErrorStream())).start();
                if (this.outTemp) {
                    new Thread(new Drainer(process.getInputStream())).start();
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {
                        throw new RuntimeException("could not wait for " + this.executable, interruptedException);
                    }
                    bufferedReader = new BufferedReader(Files.newBufferedReader(path2, this.UTF8));
                } else {
                    bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), this.UTF8));
                }
                while ((string = bufferedReader.readLine()) != null) {
                    int n2;
                    int n3;
                    String[] stringArray2;
                    int n4 = 0;
                    if (string.indexOf(this.unsatTag) != -1) {
                        this.sat = Boolean.FALSE;
                        break;
                    }
                    if (string.indexOf(this.satTag) != -1) {
                        this.sat = Boolean.TRUE;
                        continue;
                    }
                    if (this.solutionTag.length() == 0) {
                        if (this.sat != Boolean.TRUE) continue;
                        stringArray2 = string.split("\\s");
                        n3 = stringArray2.length - 1;
                        try {
                            for (n2 = 0; n2 <= n3; ++n2) {
                                int n5 = Integer.parseInt(stringArray2[n2]);
                                if (n5 == 0) continue;
                                this.updateSolution(n5);
                            }
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            break;
                        }
                    }
                    n4 = string.indexOf(this.solutionTag);
                    if (n4 == -1) continue;
                    string = string.substring(n4 + this.solutionTag.length());
                    stringArray2 = string.split("\\s");
                    n3 = stringArray2.length - 1;
                    for (n2 = 0; n2 < n3; ++n2) {
                        this.updateSolution(Integer.parseInt(stringArray2[n2]));
                    }
                    n2 = Integer.parseInt(stringArray2[n3]);
                    if (n2 != 0) {
                        this.updateSolution(n2);
                        continue;
                    }
                    if (this.sat == null) continue;
                    break;
                }
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (this.sat == null) {
                    throw new RuntimeException("invalid " + this.executable + " output (unknown result)");
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("SAT solver aborted: " + iOException, iOException);
            }
            catch (NumberFormatException numberFormatException) {
                throw new RuntimeException("invalid " + this.executable + " output", numberFormatException);
            }
            finally {
                if (process != null) {
                    process.destroy();
                    try {
                        process.waitFor();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (path != null) {
                    path.toFile().delete();
                }
                if (path2 != null) {
                    path2.toFile().delete();
                }
            }
        }
        return this.sat;
    }

    public boolean valueOf(int n) {
        if (!Boolean.TRUE.equals(this.sat)) {
            throw new IllegalStateException();
        }
        if (n < 1 || n > this.vars) {
            throw new IllegalArgumentException(n + " !in [1.." + this.vars + "]");
        }
        return this.solution.get(n - 1);
    }

    public String toString() {
        return this.executable + " " + this.options;
    }

    public static final SATFactory satFactory(final String string, String string2, final String string3, final String string4, final String string5, final String string6, final String ... stringArray) {
        return new SATFactory(){

            public SATSolver instance() {
                return new ExternalSolverV2(string, string3.length() != 0, string4, string5, string6, stringArray);
            }

            public boolean incremental() {
                return false;
            }
        };
    }

    private final class Drainer
    implements Runnable {
        private final InputStream input;

        public Drainer(InputStream inputStream) {
            this.input = inputStream;
        }

        @Override
        public void run() {
            try {
                int n;
                byte[] byArray = new byte[8192];
                while ((n = this.input.read(byArray)) >= 0) {
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

