/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.example;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class SimpleApp
extends JFrame {
    public SimpleApp(String[] args) {
        super("Java Application");
        if (args.length == 1 && "throw".equals(args[0])) {
            throw new IllegalStateException("Exception thrown from SimpleApp.");
        }
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds(screenSize.width / 4, screenSize.height / 4, screenSize.width / 2, screenSize.height / 2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.initializeMenu();
        this.initializeTextArea(args);
        this.setVisible(true);
    }

    public static void setLAF() {
        JFrame.setDefaultLookAndFeelDecorated(true);
        Toolkit.getDefaultToolkit().setDynamicLayout(true);
        System.setProperty("sun.awt.noerasebackground", "true");
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            System.err.println("Failed to set LookAndFeel");
        }
    }

    public static void main(String[] args) {
        SimpleApp.setLAF();
        new SimpleApp(args);
    }

    private final void initializeMenu() {
        JMenu menu = new JMenu("Exit with code");
        menu.add(new JMenuItem(new AbstractAction("Exit with code 0"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        }));
        menu.add(new JMenuItem(new AbstractAction("Exit with code 100 and restart the application"){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(100);
            }
        }));
        JMenuBar mb = new JMenuBar();
        mb.setOpaque(true);
        mb.add(menu);
        this.setJMenuBar(mb);
    }

    private final void initializeTextArea(String[] args) {
        JTextArea textArea = new JTextArea();
        textArea.setFont(new Font("Monospaced", 0, 12));
        textArea.setEditable(false);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(textArea);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.getContentPane().add(scrollPane);
        textArea.setText(this.getMainProperties(args));
        textArea.append(this.getAllProperties());
        textArea.append(this.getEnvironmentVariables());
    }

    private final String getMainProperties(String[] args) {
        StringBuffer sb = new StringBuffer("Java version: ");
        sb.append(System.getProperty("java.version"));
        sb.append("\nJava home: ");
        sb.append(System.getProperty("java.home"));
        sb.append("\nCurrent dir: ");
        sb.append(System.getProperty("user.dir"));
        sb.append("\nCommand line args: {");
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                sb.append(' ');
            }
            sb.append(args[i]);
        }
        sb.append("}\n");
        int mb = 0x100000;
        sb.append("Free memory (MB): ");
        sb.append(Runtime.getRuntime().freeMemory() / 0x100000L);
        sb.append("\nTotal memory (MB): ");
        sb.append(Runtime.getRuntime().totalMemory() / 0x100000L);
        sb.append("\nMax memory (MB): ");
        sb.append(Runtime.getRuntime().maxMemory() / 0x100000L);
        sb.append("\n");
        return sb.toString();
    }

    private final String getAllProperties() {
        StringBuffer sb = new StringBuffer("\n========== All properties ==========\n");
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(System.getProperties().stringPropertyNames());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(key);
            sb.append(": ");
            sb.append(System.getProperty(key));
            sb.append("\n");
        }
        return sb.toString();
    }

    private final String getEnvironmentVariables() {
        StringBuffer sb = new StringBuffer("\n========== Environment variables ==========\n");
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(System.getenv().keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append(key);
            sb.append(": ");
            sb.append(System.getenv(key));
            sb.append("\n");
        }
        return sb.toString();
    }
}

